/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.tree.Node;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HClustAdjuster {
    private static final ApplicationLogger logger = new ApplicationLogger(HClustAdjuster.class);
    private HClustCondition condition;
    private ClusterTbl clusterTbl;
    private List rootNodeList;
    private List resultRootNodeList;
    private Map clusterIdMap = new HashMap();

    HClustAdjuster(HClustCondition hClustCondition, ClusterTbl clusterTbl, List list) {
        this.condition = hClustCondition;
        this.clusterTbl = clusterTbl;
        this.rootNodeList = list;
        this.resultRootNodeList = HClustAdjuster.createCopyRootNodeList(list);
        this.clusterIdMap = this.createClusterIdMap();
    }

    public static List createCopyRootNodeList(List list) {
        ArrayList<ClusterNode> arrayList = new ArrayList<ClusterNode>();
        for (ClusterNode clusterNode : list) {
            ClusterNode clusterNode2 = ClusterNode.createClusterNodeByClusterNode(clusterNode);
            HClustAdjuster.copyClusterNode(clusterNode, clusterNode2);
            arrayList.add(clusterNode2);
        }
        return arrayList;
    }

    public void execute() {
        Object object;
        long l = System.currentTimeMillis();
        double d = this.calcMaxDist();
        long l2 = System.currentTimeMillis();
        Set set = this.createViewClusterIdSet();
        long l3 = System.currentTimeMillis();
        this.resultRootNodeList = HClustAdjuster.filterNode(this.resultRootNodeList, set);
        long l4 = System.currentTimeMillis();
        List list = NodeUtil.getLeafNodeList(this.resultRootNodeList);
        for (ClusterNode clusterNode : list) {
            Set set2 = clusterNode.getViewClusterIdSet();
            Object object2 = new HashSet();
            object = set2.iterator();
            while (object.hasNext()) {
                Object object3 = (String)object.next();
                List list2 = (List)this.clusterIdMap.get(object3);
                object2.addAll(list2);
            }
            clusterNode.setClusterSet((Set)object2);
        }
        long l5 = System.currentTimeMillis();
        for (Object object2 : this.resultRootNodeList) {
            object = NodeUtil.getLeafNodeList((Node)object2);
            NodeUtil.adjustDist((List)object);
        }
        long l6 = System.currentTimeMillis();
        for (Object object3 : this.resultRootNodeList) {
            double d2 = ((Node)object3).getMaxDist();
            ((Node)object3).setDist(((Node)object3).getDist() + d - d2);
        }
        long l7 = System.currentTimeMillis();
        logger.info("Time1:" + (l2 - l));
        logger.info("Time2:" + (l3 - l2));
        logger.info("Time3:" + (l4 - l3));
        logger.info("Time4:" + (l5 - l4));
        logger.info("Time5:" + (l6 - l5));
        logger.info("Time6:" + (l7 - l6));
    }

    private double calcMaxDist() {
        return NodeUtil.calcMaxDist(this.rootNodeList);
    }

    private static List filterNode(List list, Set set) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            ClusterNode clusterNode = (ClusterNode)list.get(i);
            HClustAdjuster.filterClusterNode(clusterNode, set);
            if (clusterNode.isLeaf() && clusterNode.isExistViewClusterId()) continue;
            if (!clusterNode.existNode1() && clusterNode.existNode2()) {
                arrayList.add(clusterNode.getNode2());
                continue;
            }
            if (clusterNode.existNode1() && !clusterNode.existNode2()) {
                arrayList.add(clusterNode.getNode1());
                continue;
            }
            arrayList.add(clusterNode);
        }
        return arrayList;
    }

    public static void filterClusterNode(ClusterNode clusterNode, Collection collection) {
        if (clusterNode.isLeaf()) {
            HashSet hashSet = new HashSet(clusterNode.getClusterIdSet());
            hashSet.retainAll(collection);
            if (CollectionUtil.isNull(hashSet)) {
                Node node = clusterNode.getParent();
                if (node != null) {
                    Node node2 = node.getParent();
                    if (node2 != null) {
                        node.removeChildNode(clusterNode);
                        node2.removeChildNode(node);
                        Node node3 = node.getRestChildNode();
                        node3.setDist(node3.getDist() + node.getDist());
                        node2.setNode(node3);
                    } else {
                        node.removeChildNode(clusterNode);
                        Node node4 = node.getRestChildNode();
                        node.copy(node4);
                        node.setParent(null);
                        HClustAdjuster.filterClusterNode((ClusterNode)node, collection);
                    }
                }
            } else {
                clusterNode.setViewClusterIdSet(hashSet);
            }
        }
        if (clusterNode.getNode1() != null) {
            HClustAdjuster.filterClusterNode((ClusterNode)clusterNode.getNode1(), collection);
        }
        if (clusterNode.getNode2() != null) {
            HClustAdjuster.filterClusterNode((ClusterNode)clusterNode.getNode2(), collection);
        }
    }

    public static void copyClusterNode(ClusterNode clusterNode, ClusterNode clusterNode2) {
        if (clusterNode.isLeaf()) {
            return;
        }
        ClusterNode clusterNode3 = ClusterNode.createClusterNodeByClusterNode((ClusterNode)clusterNode.getNode1());
        ClusterNode clusterNode4 = ClusterNode.createClusterNodeByClusterNode((ClusterNode)clusterNode.getNode2());
        clusterNode2.setNode1(clusterNode3);
        clusterNode2.setNode2(clusterNode4);
        if (!clusterNode.getNode1().isLeaf()) {
            HClustAdjuster.copyClusterNode((ClusterNode)clusterNode.getNode1(), clusterNode3);
        }
        if (!clusterNode.getNode2().isLeaf()) {
            HClustAdjuster.copyClusterNode((ClusterNode)clusterNode.getNode2(), clusterNode4);
        }
    }

    private Set createViewClusterIdSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Cluster cluster : this.clusterTbl.getViewClusterList()) {
            if (this.condition.isModeCluster()) {
                hashSet.add(String.valueOf(cluster.getClusterId()));
                continue;
            }
            hashSet.add(cluster.getConbinedClusterId("_"));
        }
        return hashSet;
    }

    public List getLeafNodeList() {
        return NodeUtil.getLeafNodeList(this.rootNodeList);
    }

    private Map createClusterIdMap() {
        Map map = null;
        map = this.condition.isModeCluster() ? this.createViewClusterMapForCluster() : this.createViewClusterMapForSubCluster();
        return map;
    }

    private Map createViewClusterMapForCluster() {
        HashMap<String, ArrayList<Cluster>> hashMap = new HashMap<String, ArrayList<Cluster>>();
        for (Cluster cluster : this.clusterTbl.getViewClusterList()) {
            ArrayList<Cluster> arrayList = (ArrayList<Cluster>)hashMap.get(String.valueOf(cluster.getClusterId()));
            if (arrayList == null) {
                arrayList = new ArrayList<Cluster>();
                hashMap.put(String.valueOf(cluster.getClusterId()), arrayList);
            }
            arrayList.add(cluster);
        }
        return hashMap;
    }

    private Map createViewClusterMapForSubCluster() {
        HashMap<String, ArrayList<Cluster>> hashMap = new HashMap<String, ArrayList<Cluster>>();
        for (Cluster cluster : this.clusterTbl.getViewClusterList()) {
            ArrayList<Cluster> arrayList = (ArrayList<Cluster>)hashMap.get(cluster.getConbinedClusterId("_"));
            if (arrayList == null) {
                arrayList = new ArrayList<Cluster>();
                hashMap.put(cluster.getConbinedClusterId("_"), arrayList);
            }
            arrayList.add(cluster);
        }
        return hashMap;
    }

    public List getResultRootNodeList() {
        return this.resultRootNodeList;
    }

    public List getResultLeafNodeList() {
        return NodeUtil.getLeafNodeList(this.resultRootNodeList);
    }
}

