/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.AbstractHClustImporter;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.tree.Node;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class NewHClustImporter
extends AbstractHClustImporter {
    static final String DELIMTER_ID_PATTERN = ":";
    static final String DELIMTER_PATTERN_ELEMENT = "\t";
    static final String DELIMTER_ELEMENTS = ",";
    static final String DELIMITER_TREE_LIST = "===";
    private boolean finishTreePart = false;
    private String treeString = "";
    private int dataRecordCount = 0;
    private List rootNodeList = new ArrayList();
    private Map patternIdClusterIdMap = new HashMap();

    NewHClustImporter(String string) {
        super(string);
    }

    protected void parseDataLine(int n, String string) {
        if (this.isDelimterTreeList(string)) {
            this.convertTreeStructure();
            this.setFinishTreePart(true);
            return;
        }
        if (!this.isFinishTreePart()) {
            if (this.isHeaderLine(string) && this.dataRecordCount != 0) {
                this.convertTreeStructure();
            } else if (!this.isHeaderLine(string)) {
                if (this.dataRecordCount != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.treeString);
                    stringBuffer.append(string);
                    String string2 = stringBuffer.toString();
                    this.treeString = this.treeParser.createTreeStructure(string2, string2.length() - string.length());
                } else {
                    this.treeString = string;
                }
                ++this.dataRecordCount;
            }
        } else {
            Vector vector = StringTool.splitString(string, DELIMTER_ID_PATTERN);
            String string3 = (String)vector.get(0);
            String string4 = (String)vector.get(1);
            vector = StringTool.splitString(string4, DELIMTER_PATTERN_ELEMENT);
            string4 = (String)vector.get(1);
            HashSet hashSet = new HashSet(StringTool.splitString(string4, DELIMTER_ELEMENTS));
            this.patternIdClusterIdMap.put(string3, hashSet);
        }
    }

    protected void afterProcess() {
        List list = this.getLeafNodeList();
        for (ClusterNode clusterNode : list) {
            String string = clusterNode.getName();
            Set set = (Set)this.patternIdClusterIdMap.get(string);
            clusterNode.setClusterIdSet(set);
        }
    }

    protected void parseHeaderLine(String string) {
    }

    protected void parseParameterLine(String string) {
        if (!ServerStatus.isParameter(string)) {
            this.setReadParameter(true);
            return;
        }
        if (ServerStatus.isStartData(string)) {
            this.setReadParameter(true);
            return;
        }
        this.setParameter(string);
    }

    private boolean isFinishTreePart() {
        return this.finishTreePart;
    }

    private void setFinishTreePart(boolean bl) {
        this.finishTreePart = bl;
    }

    private boolean isDelimterTreeList(String string) {
        return string.equals(DELIMITER_TREE_LIST);
    }

    private void convertTreeStructure() {
        this.treeParser.createTreeStructure(this.treeString, this.treeString.length());
        Node node = this.treeParser.getRootNode();
        this.rootNodeList.add(node);
        this.treeString = "";
        this.dataRecordCount = 0;
        this.treeParser.clearRootNode();
    }

    public List getLeafNodeList() {
        return NodeUtil.getLeafNodeList(this.getRootNodeList());
    }

    public List getRootNodeList() {
        return this.rootNodeList;
    }
}

