/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.DistData;
import cgdp.recog.hcluster.HClustException;
import cgdp.recog.hcluster.NodeNbrList;
import cgdp.recog.hcluster.PairDist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class NodeIndex {
    ArrayList index;
    ArrayList indexTmp = new ArrayList();

    NodeIndex() {
    }

    void addNode(int n) throws HClustException {
        if (n == this.indexTmp.size()) {
            this.indexTmp.add(new ArrayList());
        } else if (n >= this.indexTmp.size()) {
            throw new HClustException("Fail to add node. id = " + n);
        }
    }

    void addData(PairDist pairDist) {
        int n = pairDist.node1.id;
        int n2 = pairDist.node2.id;
        if (this.indexTmp != null) {
            this.addData_preproc(n, n2, pairDist);
            this.addData_preproc(n2, n, pairDist);
        } else {
            this.addData_clustering(n, pairDist);
            this.addData_clustering(n2, pairDist);
        }
    }

    void addData_preproc(int n, int n2, PairDist pairDist) {
        ((ArrayList)this.indexTmp.get(n)).add(new DistData(n2, pairDist));
    }

    void addData_clustering(int n, PairDist pairDist) {
        NodeNbrList nodeNbrList;
        if (n >= this.index.size()) {
            do {
                nodeNbrList = new NodeNbrList();
                this.index.add(nodeNbrList);
            } while (n >= this.index.size());
        } else {
            nodeNbrList = (NodeNbrList)this.index.get(n);
        }
        nodeNbrList.add(pairDist);
    }

    void convert() {
        for (int i = 0; i < this.indexTmp.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.indexTmp.get(i);
            Collections.sort(arrayList, new CompareIDs());
            NodeNbrList nodeNbrList = new NodeNbrList();
            for (DistData distData : arrayList) {
                nodeNbrList.add(distData.pdist);
            }
            this.indexTmp.set(i, nodeNbrList);
        }
        this.index = this.indexTmp;
        this.indexTmp = null;
    }

    boolean isPreprocMode() {
        return this.indexTmp != null;
    }

    NodeNbrList get(int n) {
        return (NodeNbrList)this.index.get(n);
    }

    static class CompareIDs
    implements Comparator {
        CompareIDs() {
        }

        public int compare(Object object, Object object2) {
            return ((DistData)object).id - ((DistData)object2).id;
        }
    }
}

