/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.data.Cluster;
import cgdp.recog.histogram.HistogramType;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.AbstractMultiValueCondition;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MapUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistogramCondition
extends AbstractMultiValueCondition {
    static final int GRAPH_TYPE_BAR = 1;
    static final int GRAPH_TYPE_LINE = 2;
    private int histogramType = 1;
    private List valueOrganismCodeList = new ArrayList();
    private AbstractInfoTitle valueGeneInfoTitle;
    private Color negativeColor = Color.red;
    private Color positiveColor = Color.green;
    private String primaryOrganismCode;
    private String secondaryOrganismCode;
    private AbstractInfoTitle diffGeneInfoTitle;
    private Color primaryColor = Color.green;
    private Color secondaryColor = Color.red;
    private boolean showDataLable = true;
    private int graphType = 1;
    private double minValue;
    private double maxValue;
    private Map clusterValueMap = new HashMap();
    private Map clusterOrganismValueMap = new HashMap();
    private boolean calcedRange = false;

    public int getHistogramType() {
        return this.histogramType;
    }

    public void setHistogramType(int n) {
        this.histogramType = n;
    }

    public boolean isDescriptionFunc() {
        return HistogramType.isDescriptionFunc(this.getHistogramType());
    }

    public boolean isFuncName() {
        return HistogramType.isFuncName(this.getHistogramType());
    }

    public boolean isValue() {
        return HistogramType.isValue(this.getHistogramType());
    }

    public boolean isDiff() {
        return HistogramType.isDiff(this.getHistogramType());
    }

    public List getValueOrganismCodeList() {
        return this.valueOrganismCodeList;
    }

    public void setValueOrganismCodeList(List list) {
        this.valueOrganismCodeList = list;
    }

    public boolean isMultiOrganism() {
        return !CollectionUtil.isNull(this.getValueOrganismCodeList()) && this.getValueOrganismCodeList().size() >= 2;
    }

    public boolean isStackBar() {
        return this.isMultiOrganism() && this.isBar();
    }

    public AbstractInfoTitle getValueGeneInfoTitle() {
        return this.valueGeneInfoTitle;
    }

    public void setValueGeneInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        this.valueGeneInfoTitle = abstractInfoTitle;
    }

    public Color getNegativeColor() {
        return this.negativeColor;
    }

    public void setNegativeColor(Color color) {
        this.negativeColor = color;
    }

    public Color getPositiveColor() {
        return this.positiveColor;
    }

    public void setPositiveColor(Color color) {
        this.positiveColor = color;
    }

    public String getPrimaryOrganismCode() {
        return this.primaryOrganismCode;
    }

    public void setPrimaryOrganismCode(String string) {
        this.primaryOrganismCode = string;
    }

    public String getSecondaryOrganismCode() {
        return this.secondaryOrganismCode;
    }

    public void setSecondaryOrganismCode(String string) {
        this.secondaryOrganismCode = string;
    }

    public AbstractInfoTitle getDiffGeneInfoTitle() {
        return this.diffGeneInfoTitle;
    }

    public void setDiffGeneInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        this.diffGeneInfoTitle = abstractInfoTitle;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(Color color) {
        this.primaryColor = color;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(Color color) {
        this.secondaryColor = color;
    }

    public AbstractInfoTitle getInfoTitle() {
        throw new UnsupportedOperationException("No support.");
    }

    public int indexOfElement(Object object) {
        return this.getInfoTitle().indexOfElement(object);
    }

    public boolean isAsc() {
        return true;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public Map getClusterValueMap() {
        return this.clusterValueMap;
    }

    public void setClusterValueMap(Map map) {
        this.clusterValueMap = map;
    }

    public void setClusterOrganismValueMap(Map map) {
        this.clusterOrganismValueMap = map;
    }

    public Map getClusterOrganismValueMap() {
        return this.clusterOrganismValueMap;
    }

    boolean containsValue(Cluster cluster) {
        return this.clusterValueMap.get(cluster) != null;
    }

    boolean containsValue(Cluster cluster, String string) {
        Map map = (Map)this.clusterOrganismValueMap.get(cluster);
        if (MapUtil.isNull(map)) {
            return false;
        }
        return map.containsKey(string);
    }

    public double getValue(Cluster cluster) {
        Number number = (Number)this.clusterValueMap.get(cluster);
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public double getValue(Cluster cluster, String string) {
        Map map = (Map)this.clusterOrganismValueMap.get(cluster);
        if (MapUtil.isNull(map)) {
            return 0.0;
        }
        Number number = (Number)map.get(string);
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public boolean isShowDataLable() {
        return this.showDataLable;
    }

    public void setShowLable(boolean bl) {
        this.showDataLable = bl;
    }

    public String getRepresentativeOrganismCode() {
        if (this.isValue()) {
            if (CollectionUtil.isNull(this.getValueOrganismCodeList())) {
                return null;
            }
            return (String)this.getValueOrganismCodeList().get(0);
        }
        if (this.isDiff()) {
            return this.getPrimaryOrganismCode();
        }
        return null;
    }

    public void setCalcedRange(boolean bl) {
        this.calcedRange = bl;
    }

    public boolean isCalcedRange() {
        return this.calcedRange;
    }

    public int getGraphType() {
        return this.graphType;
    }

    public void setGraphType(int n) {
        this.graphType = n;
    }

    public boolean isBar() {
        return this.getGraphType() == 1;
    }

    public boolean isLine() {
        return this.getGraphType() == 2;
    }

    public boolean containsInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        if (this.isValue()) {
            return this.getValueGeneInfoTitle().equals(abstractInfoTitle);
        }
        if (this.isDiff()) {
            return this.getDiffGeneInfoTitle().equals(abstractInfoTitle);
        }
        return false;
    }
}

