/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ColorTbl;
import cgdp.recog.histogram.GeneValueRenderer;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StackBarRenderer
extends GeneValueRenderer {
    StackBarRenderer() {
    }

    public void draw(Graphics2D graphics2D) {
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        graphics2D.setFont(this.context.getFont());
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.context.getWidth(), this.context.getHeight());
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getBorderLineColorString());
        ArrayList arrayList = new ArrayList(this.context.getViewClusterList());
        double d = this.context.calcIntervalY(arrayList.size());
        double d2 = d < 1.0 ? 1.0 : d;
        double d3 = this.context.calcScaleX();
        double d4 = this.context.getOffsetTop();
        double d5 = this.context.calcX(d3, 0.0);
        for (int i = 0; i < arrayList.size() && i < this.context.getRowCount(); ++i) {
            int n = i + this.context.getStartRow();
            Cluster cluster = (Cluster)arrayList.get(n);
            this.drawBar(graphics2D, cluster, d3, d5, d4, d2);
            this.drawBorderLine(graphics2D, d4, d2, color);
            this.drawSelectBorderLine(graphics2D, n, d4, d2);
            d4 += d;
        }
        this.drawScale(graphics2D);
    }

    private void drawBar(Graphics2D graphics2D, Cluster cluster, double d, double d2, double d3, double d4) {
        Map map = this.createColorValueMap();
        double d5 = d2;
        double d6 = d2;
        for (Color color : map.keySet()) {
            graphics2D.setColor(color);
            List list = (List)map.get(color);
            for (String string : list) {
                graphics2D.setColor(color);
                double d7 = this.context.getValue(cluster, string);
                double d8 = this.context.calcX(d, d7);
                double d9 = Math.abs(d8 - d2);
                if (d7 < 0.0) {
                    graphics2D.fill(new Rectangle2D.Double(d6, d3, d9, this.adjustCellHeight(d4)));
                    d6 -= d9;
                    continue;
                }
                if (!(d7 > 0.0)) continue;
                graphics2D.fill(new Rectangle2D.Double(d5, d3, d9, this.adjustCellHeight(d4)));
                d5 += d9;
            }
        }
    }

    private Map createColorValueMap() {
        HashMap<Color, ArrayList<String>> hashMap = new HashMap<Color, ArrayList<String>>();
        for (String string : this.context.getValueOrganismCodeList()) {
            ArrayList<String> arrayList;
            if (!this.context.isShowOrganism(string)) continue;
            Color color = ColorTbl.getInstance().getColor(string);
            if (color == null) {
                color = ColorTbl.DEFAULT_COLOR;
            }
            if ((arrayList = (ArrayList<String>)hashMap.get(color)) == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(color, arrayList);
            }
            arrayList.add(string);
        }
        return hashMap;
    }
}

