/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info;

import cgdp.recog.info.AbstractInfoTabPanel;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.CalcOptionPanel;
import cgdp.recog.info.InfoClass;
import cgdp.recog.info.InfoEditPanel;
import cgdp.recog.util.TabDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.List;

public class InfoEditDialog
extends TabDialog {
    public static final String NAME_GENERAL = "General";
    public static final String NAME_CALC = "Calculation";
    private InfoEditPanel infoEditPanel;
    private CalcOptionPanel calcOptionPanel;
    private AbstractInfoTitle infoTitle;
    private AbstractInfoTabPanel infoTabPanel;

    public InfoEditDialog(Frame frame) {
        super(frame);
        this.setShowDefaultButton(false);
        this.createComponents();
        this.setModal(false);
    }

    public InfoEditDialog(Dialog dialog) {
        super(dialog);
        this.setShowDefaultButton(false);
        this.createComponents();
        this.setModal(false);
    }

    public static InfoEditDialog getInstance(Component component) {
        if (component instanceof Frame) {
            return new InfoEditDialog((Frame)component);
        }
        return new InfoEditDialog((Dialog)component);
    }

    protected void addTabPanel() {
        this.infoEditPanel = new InfoEditPanel(this);
        this.calcOptionPanel = new CalcOptionPanel(this);
        this.tabbedPane.add(NAME_GENERAL, this.infoEditPanel);
        this.tabbedPane.add(NAME_CALC, this.calcOptionPanel);
    }

    public void updateValue(AbstractInfoTitle abstractInfoTitle) {
        this.updateValue(abstractInfoTitle, null, null);
        this.tabbedPane.setEnabledAt(0, false);
        this.tabbedPane.setSelectedIndex(1);
        this.setModal(true);
    }

    public void updateValue(AbstractInfoTitle abstractInfoTitle, List list, AbstractInfoTabPanel abstractInfoTabPanel) {
        this.infoTitle = abstractInfoTitle;
        this.infoTabPanel = abstractInfoTabPanel;
        this.infoEditPanel.updateValue(abstractInfoTitle);
        this.calcOptionPanel.updateValue(abstractInfoTitle, list, abstractInfoTabPanel);
        this.setTitle(this.getFrameTitle(abstractInfoTitle.getCls()));
        this.pack();
    }

    protected boolean processApply() {
        this.setParameter(this.infoTitle);
        if (this.infoTabPanel != null) {
            this.infoTabPanel.addEditInfoTitle(this.infoTitle);
            this.infoTabPanel.updateTable(this.infoTitle);
        }
        return true;
    }

    private void setParameter(AbstractInfoTitle abstractInfoTitle) {
        this.infoEditPanel.setParameter(abstractInfoTitle);
        this.calcOptionPanel.setParameter(abstractInfoTitle);
    }

    private String getFrameTitle(int n) {
        String string = "Edit ";
        if (InfoClass.isGene(n)) {
            string = string + "gene property";
        } else if (InfoClass.isCell(n)) {
            string = string + "cell property";
        } else if (InfoClass.isCluster(n)) {
            string = string + "cluster property";
        }
        return string;
    }
}

