/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.bean.Const;
import cgdp.recog.info.AbstractInfoConfExporter;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;

public class ClusterInfoConfExporter
extends AbstractInfoConfExporter {
    public ClusterInfoConfExporter(List list) {
        this(list, Const.USER_CLUSTER_INFO_PATH);
    }

    public ClusterInfoConfExporter(List list, String string) {
        super(list, string);
    }

    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StringTool.conbineStrList(this.getHeaderNameList(), "\t"));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (ClusterInfoTitle clusterInfoTitle : this.infoTitleList) {
            stringBuffer.append(this.createLine(clusterInfoTitle));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    private String createLine(ClusterInfoTitle clusterInfoTitle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(clusterInfoTitle.getName());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.getKey());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.getTypeString());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.getCategory());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.getLocationName());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.getInfoType());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.isEditable());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.isServerSearchEnable());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.getSearchEqualType());
        stringBuffer.append("\t");
        stringBuffer.append(clusterInfoTitle.isCacheNeed());
        stringBuffer.append("\t");
        stringBuffer.append(this.createAnalysisOptionLine(clusterInfoTitle));
        stringBuffer.append("\t");
        stringBuffer.append(this.createCalcOptionLine(clusterInfoTitle));
        stringBuffer.append("\t");
        stringBuffer.append(StringTool.conbineStrList(clusterInfoTitle.getDomClustIdSet(), ","));
        return stringBuffer.toString();
    }

    protected List getHeaderNameList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Name");
        arrayList.add("Key");
        arrayList.add("Type");
        arrayList.add("Category");
        arrayList.add("Location");
        arrayList.add("ClusterInfoType");
        arrayList.add("Editable");
        arrayList.add("ServerSearchEnable");
        arrayList.add("SearchEqualType");
        arrayList.add("NeedCache");
        for (n = 0; n < ANALYSIS_HEADERS.length; ++n) {
            arrayList.add(ANALYSIS_HEADERS[n]);
        }
        for (n = 0; n < CALC_HEADERS.length; ++n) {
            arrayList.add(CALC_HEADERS[n]);
        }
        arrayList.add("DomClust ID");
        return arrayList;
    }
}

