/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.calc.CalculateType;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoOptionLinkLabel;
import cgdp.recog.info.InfoTitleComboBox;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoConvertCondition;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.organism.OrganismSet;
import cgdp.recog.organism.OrganismSetComboBox;
import cgdp.recog.organism.OrganismSetFactory;
import cgdp.recog.organism.OrganismSetGroup;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClusterInfoConvertDialog
extends AbstractApplyDialog
implements ItemListener {
    private static ClusterInfoConvertDialog CLUSTER_INFO_CONVERT_DIALOG;
    private static final String TITLE = "Convert into gene property to cluster property";
    private FocusTextField nameTextField;
    private OrganismSetComboBox organismSetComboBox;
    private InfoTitleComboBox infoTitleComboBox;
    private JLabel infoOptionLinkLabel;
    private JComboBox ruleComboBox;
    private String domClustId;
    private int clusterInfoType = -1;

    public ClusterInfoConvertDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public static void createIntance(Frame frame) {
        CLUSTER_INFO_CONVERT_DIALOG = new ClusterInfoConvertDialog(frame);
    }

    public static ClusterInfoConvertDialog getInstance() {
        return CLUSTER_INFO_CONVERT_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField(30);
        JLabel jLabel2 = new JLabel("Organism");
        this.organismSetComboBox = new OrganismSetComboBox();
        this.organismSetComboBox.addItemListener(this);
        JLabel jLabel3 = new JLabel("Property");
        this.infoTitleComboBox = new InfoTitleComboBox();
        this.infoOptionLinkLabel = new InfoOptionLinkLabel("Option...", this, this.infoTitleComboBox);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.infoTitleComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.infoOptionLinkLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        JLabel jLabel4 = new JLabel("Rule");
        this.ruleComboBox = new JComboBox<String>(CalculateType.NAME_RULES);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.organismSetComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 0), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.ruleComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 15), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 15, 10, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(List list, String string, int n) {
        this.domClustId = string;
        this.clusterInfoType = n;
        this.updateOrganismSet(list);
        this.updateInfoTitle(list);
    }

    private void updateOrganismSet(List list) {
        OrganismSetGroup organismSetGroup = OrganismSetGroup.getInstance();
        List list2 = organismSetGroup.getOrganismSetList();
        ArrayList<OrganismSet> arrayList = new ArrayList<OrganismSet>();
        arrayList.add(OrganismSetFactory.createAllOrganismSet(list));
        arrayList.addAll(list2);
        this.organismSetComboBox.updateOrganismSetItem(arrayList);
        this.organismSetComboBox.setSelectedIndex(0);
    }

    private void updateInfoTitle(Collection collection) {
        List list = GeneInfoFacade.getGeneInfoTitleList(collection);
        list.addAll(CellInfoFacade.getInfoTitleListByAnalysisKey("UseAllAnalysis"));
        list = InfoUtil.filterByType(list, 1);
        this.infoTitleComboBox.updateInfoTitleItems(list);
    }

    private String getClusterInfoName() {
        return this.nameTextField.getText();
    }

    public OrganismSet getOrganismSet() {
        return this.organismSetComboBox.getOrganismSet();
    }

    private List getOrganismCodeList() {
        OrganismSet organismSet = this.getOrganismSet();
        if (organismSet == null) {
            return new ArrayList();
        }
        return organismSet.getOrganismCodeList();
    }

    private AbstractInfoTitle getInfoTitle() {
        return this.infoTitleComboBox.getSelectedInfoTitle();
    }

    private int getCalcType() {
        String string = (String)this.ruleComboBox.getSelectedItem();
        return CalculateType.name2Type(string);
    }

    public ClusterInfoConvertCondition createCondition() {
        Project project = ProjectAccesser.getSelectedProject();
        ClusterInfoConvertCondition clusterInfoConvertCondition = new ClusterInfoConvertCondition();
        clusterInfoConvertCondition.setName(this.getClusterInfoName());
        clusterInfoConvertCondition.setProject(project);
        clusterInfoConvertCondition.setClusterInfoType(this.clusterInfoType);
        clusterInfoConvertCondition.setDomClustId(this.domClustId);
        clusterInfoConvertCondition.setOrganismCodeC(this.getOrganismCodeList());
        clusterInfoConvertCondition.setCalcType(this.getCalcType());
        clusterInfoConvertCondition.setInfoTitle(this.getInfoTitle());
        clusterInfoConvertCondition.setMultiElementType(this.getInfoTitle().getMultiElementType());
        clusterInfoConvertCondition.setMultiInfoType(this.getInfoTitle().getMultiInfoType());
        clusterInfoConvertCondition.updateCalcOption(this.getInfoTitle());
        return clusterInfoConvertCondition;
    }

    protected boolean check() {
        String string = this.getClusterInfoName();
        if (StringTool.isNull(string)) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        ClusterInfoConvertCondition clusterInfoConvertCondition = this.createCondition();
        ClusterInfoTitle clusterInfoTitle = clusterInfoConvertCondition.createClusterInfoTitle();
        return ClusterInfoFacade.validateInfoTitle((Component)this, clusterInfoTitle);
    }

    protected boolean apply() {
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.organismSetComboBox) {
            OrganismSet organismSet = this.organismSetComboBox.getOrganismSet();
            if (organismSet == null) {
                return;
            }
            List list = organismSet.getOrganismCodeList();
            this.updateInfoTitle(list);
        }
    }
}

