/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.cluster;

import cgdp.recog.info.InfoComparator;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.project.Project;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.URLList;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ClusterInfoDownloader
extends AbstractServerResourceAccesser {
    private static final String DELIMITER = "\t";
    private String domClustId;
    private ClusterInfoTitle clusterInfoTitle;
    private int clusteInfoType = -1;
    private Map clusterInfoMap = new HashMap();
    private int dataCount = 0;

    public ClusterInfoDownloader(ClusterInfoTitle clusterInfoTitle, String string, Project project) {
        this.clusterInfoTitle = clusterInfoTitle;
        this.domClustId = string;
        this.setProject(project);
        this.setContextPath(URLList.getInstance().getGetClusterProp());
        this.setOptions();
    }

    public void parseOutputStringData(int n, String string) {
        if (this.dataCount == 0) {
            ++this.dataCount;
            return;
        }
        ++this.dataCount;
        Vector vector = StringTool.splitString(string, DELIMITER);
        String string2 = (String)vector.get(0);
        if (ClusterInfoType.isNoSelect(this.clusteInfoType)) {
            this.setClusterInfoType(string2);
            this.clusterInfoTitle.setInfoType(this.clusteInfoType);
        }
        Object object = this.clusterInfoTitle.getValueAsType(vector.get(1));
        ClusterInfo clusterInfo = (ClusterInfo)this.clusterInfoMap.get(string2);
        if (clusterInfo == null) {
            clusterInfo = new ClusterInfo();
            clusterInfo.putInfo(ClusterInfoTitle.TITLE_ID, string2);
            this.clusterInfoMap.put(string2, clusterInfo);
        }
        if (this.clusterInfoTitle.isMulti()) {
            List list = clusterInfo.getMultiInfo(this.clusterInfoTitle);
            list.add(object);
            clusterInfo.putMultiInfo(this.clusterInfoTitle, list);
        } else {
            clusterInfo.putInfo(this.clusterInfoTitle, object);
        }
    }

    private void setClusterInfoType(String string) {
        if (!ClusterInfoType.isNoSelect(this.clusteInfoType)) {
            return;
        }
        this.clusteInfoType = string.indexOf(".") != -1 ? 4 : 3;
    }

    private void setOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("prop_name=" + this.clusterInfoTitle.getName());
        stringBuffer.append("&tabid=");
        stringBuffer.append(this.domClustId);
        this.setOptions(stringBuffer.toString());
    }

    public int getClusteInfoType() {
        return this.clusteInfoType;
    }

    public List getClusterInfoList() {
        ArrayList arrayList = new ArrayList(this.clusterInfoMap.values());
        Collections.sort(arrayList, new InfoComparator(ClusterInfoFacade.getInfoTitle("##ID")));
        return arrayList;
    }
}

