/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.info.InfoComparator;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.project.Project;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.system.Codec;
import cgdp.recog.system.URLList;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class GeneInfoDownloader
extends AbstractServerResourceAccesser {
    private static final String DELIMITER = "\t";
    private static final String DELIMITER_SP = ",";
    private Collection organismCodeC;
    private GeneInfoTitle geneInfoTitle;
    private Map geneInfoMap = new HashMap();
    private int dataCount = 0;

    public GeneInfoDownloader(GeneInfoTitle geneInfoTitle, Collection collection, Project project) throws UnsupportedEncodingException {
        this.geneInfoTitle = geneInfoTitle;
        this.organismCodeC = collection;
        this.setProject(project);
        this.setContextPath(URLList.getInstance().getGetGeneProp());
        this.setOptions();
    }

    public void parseOutputStringData(int n, String string) {
        if (this.dataCount == 0) {
            ++this.dataCount;
            return;
        }
        Vector vector = StringTool.splitString(string, DELIMITER);
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        Object object = this.geneInfoTitle.getValueAsType(vector.get(2));
        String string4 = GeneUtil.createOrganismLocusTagKey(string2, string3);
        GeneInfo geneInfo = (GeneInfo)this.geneInfoMap.get(string4);
        if (geneInfo == null) {
            geneInfo = new GeneInfo();
            this.geneInfoMap.put(string4, geneInfo);
            geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string2);
            geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, string3);
        }
        if (this.geneInfoTitle.isMulti()) {
            List list = geneInfo.getMultiInfo(this.geneInfoTitle);
            list.add(object);
            geneInfo.putMultiInfo(this.geneInfoTitle, list);
        } else {
            geneInfo.putInfo(this.geneInfoTitle, object);
        }
        ++this.dataCount;
    }

    private void setOptions() throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("prop_name=" + Codec.encode(this.geneInfoTitle.getName()));
        stringBuffer.append("&spec=" + StringTool.conbineStrList(this.organismCodeC, DELIMITER_SP));
        this.setOptions(stringBuffer.toString());
    }

    public List getGeneInfoList() {
        ArrayList arrayList = new ArrayList(this.geneInfoMap.values());
        ArrayList<GeneInfoTitle> arrayList2 = new ArrayList<GeneInfoTitle>();
        arrayList2.add(GeneInfoTitle.TITLE_ORGANISM_CODE);
        arrayList2.add(GeneInfoTitle.TITLE_LOCUS_TAG_USER);
        Collections.sort(arrayList, new InfoComparator(arrayList2));
        return arrayList;
    }
}

