/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataManager;
import cgdp.recog.info.InfoExporter;
import cgdp.recog.info.InfoTitleKeyComparator;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoHeaderExporter;
import cgdp.recog.info.gene.GeneInfoListExporter;
import cgdp.recog.info.gene.GeneInfoListImporter;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GeneInfoEditExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoEditExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private List modifiedGeneInfoTitleList;
    private List errorList = new ArrayList();
    private Set newInfoTitleSet = new HashSet();
    private Set editInfoTitleSet = new HashSet();
    private Set deleteInfoTitleSet = new HashSet();

    GeneInfoEditExecuter(Component component, MediatorImpl mediatorImpl, List list, Set set, Set set2, Set set3) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.modifiedGeneInfoTitleList = list;
        this.deleteInfoTitleSet = set3;
        this.editInfoTitleSet = set2;
        this.newInfoTitleSet = set;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setCount(29);
        progressImpl.increment();
        Map map = this.createLocationGeneInfoSetMap(this.deleteInfoTitleSet);
        this.errorList.addAll(this.removeGeneInfo(map));
        progressImpl.setCount(49);
        progressImpl.increment();
        Map map2 = this.createLocationGeneInfoSetMap(this.editInfoTitleSet);
        this.errorList.addAll(this.editGeneInfo(map2));
        progressImpl.setCount(89);
        progressImpl.increment();
        try {
            Collections.sort(this.modifiedGeneInfoTitleList, new InfoTitleKeyComparator(GeneInfoTitle.getSystemGeneInfoTitleKeyList()));
            GeneInfoFacade.exportTitleList(this.modifiedGeneInfoTitleList);
        }
        catch (IOException iOException) {
            logger.warn("Fail to save gene_info file.", iOException);
        }
        progressImpl.setCount(99);
        progressImpl.increment();
    }

    private Map createLocationGeneInfoSetMap(Set set) {
        HashMap<String, HashSet<GeneInfoTitle>> hashMap = new HashMap<String, HashSet<GeneInfoTitle>>();
        for (GeneInfoTitle geneInfoTitle : set) {
            String string = geneInfoTitle.getLocationName();
            HashSet<GeneInfoTitle> hashSet = (HashSet<GeneInfoTitle>)hashMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<GeneInfoTitle>();
                hashMap.put(string, hashSet);
            }
            hashSet.add(geneInfoTitle);
        }
        return hashMap;
    }

    private List editGeneInfo(Map map) {
        ArrayList arrayList = new ArrayList();
        for (String string : map.keySet()) {
            Set set = (Set)map.get(string);
            arrayList.addAll(this.editGeneInfo(string, set));
        }
        return arrayList;
    }

    private List editGeneInfo(String string, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.createOrganismGeneInfoTitleMap(set);
        Map map2 = ProjectAccesser.createNameProjectMap();
        for (String string2 : map.keySet()) {
            String string3 = this.getGeneInfoFilepath(string2, string, map2);
            Set set2 = (Set)map.get(string2);
            try {
                GeneInfoHeaderExporter geneInfoHeaderExporter = GeneInfoHeaderExporter.createInstance(string3, string, set2);
                geneInfoHeaderExporter.execute();
            }
            catch (Exception exception) {
                logger.warn("Fail to edit gene property file. " + string2, exception);
                arrayList.add(this.getErrorMessage(string2, set));
            }
        }
        return arrayList;
    }

    private List removeGeneInfo(Map map) {
        ArrayList arrayList = new ArrayList();
        for (String string : map.keySet()) {
            Set set = (Set)map.get(string);
            arrayList.addAll(this.removeGeneInfo(string, set));
        }
        return arrayList;
    }

    private List removeGeneInfo(String string, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.createOrganismGeneInfoTitleMap(set);
        Map map2 = ProjectAccesser.createNameProjectMap();
        for (String string2 : map.keySet()) {
            String string3 = this.getGeneInfoFilepath(string2, string, map2);
            Set set2 = (Set)map.get(string2);
            try {
                GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(string3, string);
                geneInfoListImporter.execute();
                List list = geneInfoListImporter.getInfoTitleList();
                list.removeAll(set2);
                if (list.size() == 2) {
                    FileUtil.delete(string3);
                    continue;
                }
                Map map3 = geneInfoListImporter.getGeneInfoMap();
                List list2 = (List)map3.get(string2);
                if (CollectionUtil.isNull(list2)) continue;
                for (GeneInfo geneInfo : list2) {
                    geneInfo.removeAllInfo(set2);
                }
                InfoExporter infoExporter = GeneInfoListExporter.createSystemExporter(string3, string2, list2);
                infoExporter.execute();
            }
            catch (Exception exception) {
                logger.warn("Fail to delete gene property. " + string2, exception);
                arrayList.add(this.getErrorMessage(string2, set));
            }
        }
        return arrayList;
    }

    private String getErrorMessage(String string, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeneInfoTitle geneInfoTitle : set) {
            arrayList.add(geneInfoTitle.getName());
        }
        Collections.sort(arrayList);
        return string + "[" + StringTool.conbineStrList(arrayList, ",") + "]";
    }

    private Map createOrganismGeneInfoTitleMap(Set set) {
        HashMap<String, HashSet<GeneInfoTitle>> hashMap = new HashMap<String, HashSet<GeneInfoTitle>>();
        for (GeneInfoTitle geneInfoTitle : set) {
            Set set2 = geneInfoTitle.getOrganismCodeSet();
            for (String string : set2) {
                HashSet<GeneInfoTitle> hashSet = (HashSet<GeneInfoTitle>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<GeneInfoTitle>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(geneInfoTitle);
            }
        }
        return hashMap;
    }

    private String getGeneInfoFilepath(String string, String string2, Map map) {
        String string3;
        if (LocationType.isNameGlobal(string2)) {
            string3 = DataManager.getUserDefDataGeneInfoFilepath(string);
        } else {
            Project project = (Project)map.get(string2);
            if (project == null) {
                return null;
            }
            string3 = DataManager.getUserDefProjectGeneInfoFilepath(project, string);
        }
        return string3;
    }

    public void done() {
        if (CollectionUtil.isNull(this.errorList)) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.deleteInfoTitleSet);
            hashSet.addAll(this.editInfoTitleSet);
            this.mediator.updateInfoTitle(hashSet);
            return;
        }
        String[] stringArray = new String[this.errorList.size() + 1];
        stringArray[0] = "Fail to save the following properties.";
        for (int i = 0; i < this.errorList.size(); ++i) {
            stringArray[i + 1] = (String)this.errorList.get(i);
        }
        MessageManager.showErrorMessage(this.parent, stringArray);
    }
}

