/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.info.gene;

import cgdp.recog.data.DataManager;
import cgdp.recog.info.InfoComparator;
import cgdp.recog.info.InfoExporter;
import cgdp.recog.info.LocationType;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoListExporter;
import cgdp.recog.info.gene.GeneInfoListImporter;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.MessageManager;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GeneInfoRegister
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneInfoRegister.class);
    private Component parent;
    private String filepath;
    private String location;

    public GeneInfoRegister(Component component, String string, String string2) {
        this.parent = component;
        this.filepath = string;
        this.location = string2;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            GeneInfoListImporter geneInfoListImporter = GeneInfoListImporter.createRegisterGeneInfoImporter(this.filepath, this.location);
            geneInfoListImporter.execute();
            if (geneInfoListImporter.isError()) {
                MessageManager.showErrorMessage(this.parent, geneInfoListImporter.getErrorMessage());
                return;
            }
            List list = geneInfoListImporter.getInfoTitleList();
            Map map = geneInfoListImporter.getGeneInfoMap();
            List list2 = GeneInfoFacade.getGeneInfoTitleList();
            if (!this.validateInfoTitle(list, list2)) {
                return;
            }
            int n = 29;
            progressImpl.setCount(n);
            progressImpl.increment();
            GeneInfoRegister.saveGeneInfo(this.location, list, map, 30, 70.0, progressImpl);
            n = 99;
            progressImpl.setCount(n);
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to save gene property file.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(this.parent, string);
        }
    }

    public static void saveGeneInfo(String string, List list, Map map) throws Exception {
        GeneInfoRegister.saveGeneInfo(string, list, map, 0, 0.0, new DummyProgressComponent());
    }

    private static void saveGeneInfo(String string, List list, Map map, int n, double d, ProgressImpl progressImpl) throws Exception {
        Object object;
        int n2 = n;
        int n3 = (int)(70.0 / ((double)map.size() * 2.0));
        HashSet<GeneInfoTitle> hashSet = new HashSet<GeneInfoTitle>();
        for (Object object2 : map.keySet()) {
            Object object3;
            Object object4;
            Object object5 = (List)map.get(object2);
            Map map2 = GeneInfoUtil.createLocusTagGeneInfoMap((Collection)object5);
            GeneInfoRegister.addGeneInfoTitltList((List)object5, list);
            object = GeneInfoRegister.getLocalFilepath((String)object2, string);
            File file = new File((String)object).getParentFile();
            if (!file.isDirectory()) {
                file.mkdir();
            }
            if (new File((String)object).isFile()) {
                object4 = GeneInfoListImporter.createRegisterGeneInfoImporter((String)object, string);
                ((FileImporter)object4).execute();
                object3 = ((GeneInfoListImporter)object4).getInfoTitleList();
                List list2 = ((GeneInfoListImporter)object4).getGeneInfoList();
                Map map3 = GeneInfoUtil.createLocusTagGeneInfoMap(list2);
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    GeneInfoTitle geneInfoTitle = (GeneInfoTitle)iterator.next();
                    if (list.contains(geneInfoTitle)) continue;
                    hashSet.add(geneInfoTitle);
                    for (String string2 : map3.keySet()) {
                        GeneInfo geneInfo = (GeneInfo)map3.get(string2);
                        if (geneInfo == null) continue;
                        GeneInfo geneInfo2 = (GeneInfo)map2.get(string2);
                        if (geneInfo2 == null) {
                            geneInfo2 = new GeneInfo();
                            map2.put(string2, geneInfo2);
                        }
                        geneInfo2.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, geneInfo.getLocusTag());
                        geneInfo2.putInfo(geneInfoTitle, geneInfo.getInfo(geneInfoTitle));
                    }
                }
            }
            progressImpl.setCount(n2 += n3);
            progressImpl.increment();
            object4 = new ArrayList(map2.values());
            Collections.sort((List)object4, new InfoComparator(GeneInfoTitle.TITLE_LOCUSTAG_SERVER));
            object3 = GeneInfoListExporter.createSystemExporter((String)object, (String)object2, (List)object4);
            ((InfoExporter)object3).execute();
            progressImpl.setCount(n2 += n3);
            progressImpl.increment();
        }
        list.addAll(hashSet);
        List list3 = GeneInfoFacade.getGeneInfoTitleList();
        for (Object object5 : list) {
            if (list3.contains(object5)) {
                int n4 = list3.indexOf(object5);
                object = (GeneInfoTitle)list3.get(n4);
                ((GeneInfoTitle)object).addAllOrganismCode(((GeneInfoTitle)object5).getOrganismCodeSet());
                continue;
            }
            list3.add(object5);
        }
        GeneInfoFacade.exportTitleList(list3);
    }

    private static String getLocalFilepath(String string, String string2) {
        String string3;
        if (LocationType.isNameGlobal(string2)) {
            string3 = DataManager.getUserDefDataGeneInfoFilepath(string);
        } else {
            Project project = ProjectAccesser.getProject(string2);
            string3 = DataManager.getUserDefProjectGeneInfoFilepath(project, string);
        }
        return string3;
    }

    private static void addGeneInfoTitltList(List list, List list2) {
        ArrayList arrayList = new ArrayList(list2);
        arrayList.remove(GeneInfoTitle.TITLE_ORGANISM_CODE);
        for (GeneInfo geneInfo : list) {
            geneInfo.addAllInfoTitle(arrayList);
        }
    }

    private boolean validateInfoTitle(List list, List list2) {
        if (!list.contains(GeneInfoTitle.TITLE_ORGANISM_CODE)) {
            String[] stringArray = new String[]{"This file is not include [Organism] column."};
            MessageManager.showErrorMessage(this.parent, stringArray);
            return false;
        }
        if (!list.contains(GeneInfoTitle.TITLE_LOCUS_TAG_USER) && !list.contains(GeneInfoTitle.TITLE_LOCUSTAG_SERVER)) {
            String[] stringArray = new String[]{"This file is not include [LocusTag] column."};
            MessageManager.showErrorMessage(this.parent, stringArray);
            return false;
        }
        return GeneInfoFacade.validateInfoTitle(this.parent, list, list2);
    }

    public void done() {
    }
}

