/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.data.Chromosome;
import cgdp.recog.mapping.MapRecode;

public class ContigGap {
    private MapRecode contigMapRecode;
    private MapRecode gapMapRecode;

    public void setContigMapRecode(MapRecode mapRecode) {
        this.contigMapRecode = mapRecode;
    }

    public MapRecode getContigMapRecode() {
        return this.contigMapRecode;
    }

    public void setGapMapRecode(MapRecode mapRecode) {
        this.gapMapRecode = mapRecode;
    }

    public MapRecode getGapMapRecode() {
        return this.gapMapRecode;
    }

    public boolean isExistContig() {
        return this.getContigMapRecode() != null;
    }

    public int getContigId() {
        return this.getContigMapRecode().getContig().getId();
    }

    public String getContigName() {
        return this.getContigMapRecode().getContig().getDisplayName();
    }

    public int getContigLength() {
        return this.getContigMapRecode().getLength();
    }

    public int getContigDirection() {
        return this.getContigMapRecode().getDirection();
    }

    public String getDisplayDirection() {
        return this.getContigMapRecode().getGeneDirection().getDisplayDirection();
    }

    public void setDisplayDirection(String string) {
        this.getContigMapRecode().getGeneDirection().setDisplayDirection(string);
    }

    public int getLength() {
        int n = this.getGapLength();
        if (this.getContigMapRecode() != null) {
            n += this.getContigMapRecode().getLength();
        }
        return n;
    }

    public int getGapLength() {
        return this.getGapMapRecode().getLength();
    }

    public void setGapLength(int n) {
        if (this.getGapMapRecode() == null) {
            this.setGapMapRecode(MapRecode.createGapMapRecode());
        }
        this.getGapMapRecode().setTo(n);
        this.getGapMapRecode().setFrom(1);
    }

    public void setSeqNo(String string) {
        this.getGapMapRecode().setSeqNo(string);
        if (this.getContigMapRecode() != null) {
            this.getContigMapRecode().setSeqNo(string);
        }
    }

    public void setOrganismCode(String string) {
        this.getGapMapRecode().setOrganismCode(string);
        if (this.getContigMapRecode() != null) {
            this.getContigMapRecode().setOrganismCode(string);
        }
    }

    public Chromosome getChromosome() {
        return this.getContigMapRecode().getChromosome();
    }

    public void setChromosome(Chromosome chromosome) {
        if (this.getContigMapRecode() != null) {
            this.getContigMapRecode().setChromosome(chromosome);
        }
        this.getGapMapRecode().setChromosome(chromosome);
    }

    public void clearChromosome() {
        if (this.getContigMapRecode() != null) {
            this.getContigMapRecode().setChromosome(null);
        }
        this.getGapMapRecode().setChromosome(null);
    }
}

