/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mapping;

import cgdp.recog.bean.Const;
import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.Contig;
import cgdp.recog.data.ContigComparator;
import cgdp.recog.data.ContigImporter;
import cgdp.recog.data.DataManager;
import cgdp.recog.data.Genome;
import cgdp.recog.data.GenomeTbl;
import cgdp.recog.mapping.ChromosomeIdExporter;
import cgdp.recog.mapping.ChromosomeIdImporter;
import cgdp.recog.mapping.ChromosomeNoComparator;
import cgdp.recog.mapping.ContigGap;
import cgdp.recog.mapping.ContigGapGroup;
import cgdp.recog.mapping.DefaultMapCreater;
import cgdp.recog.mapping.MapConf;
import cgdp.recog.mapping.MapConfComparator;
import cgdp.recog.mapping.MapConfExporter;
import cgdp.recog.mapping.MapConfImporter;
import cgdp.recog.mapping.MapExporter;
import cgdp.recog.mapping.MapImporter;
import cgdp.recog.mapping.MapManager;
import cgdp.recog.mapping.MapRecode;
import cgdp.recog.mapping.MapRecodeComparator;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapFacade {
    private static final ApplicationLogger logger = new ApplicationLogger(MapFacade.class);
    private static final MapManager MAP_MANAGER = new MapManager();

    private MapFacade() {
    }

    public static boolean createDataDirectory() {
        Project project = ProjectAccesser.getSelectedProject();
        boolean bl = false;
        bl |= FileUtil.createDirectory(DataManager.getProjectChromosomeDirPath());
        bl |= FileUtil.createDirectory(DataManager.getProjectGeneDirPath());
        return bl |= FileUtil.createDirectory(DataManager.getProjectMappingDirpath(project));
    }

    public static List getDefaultMapRecodeList(String string) throws IOException {
        String string2 = DataManager.getGlobalMappingFilePath(string);
        return MapFacade.getMapRecodeListCore(string, string2);
    }

    public static List geMapRecodeList(String string, String string2) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        String string3 = DataManager.getProjectMappingFilepath(project, string2);
        System.err.println("filepath=" + string3);
        return MapFacade.getMapRecodeListCore(string, string3);
    }

    public static Map createContigGapListMap(List list) {
        List list2;
        int n;
        Object object2;
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new MapRecodeComparator());
        HashMap hashMap = new HashMap();
        for (Object object2 : arrayList) {
            n = ((MapRecode)object2).getChrId();
            list2 = (ArrayList<Object>)hashMap.get(new Integer(n));
            if (list2 == null) {
                list2 = new ArrayList<Object>();
                hashMap.put(new Integer(n), list2);
            }
            list2.add(object2);
        }
        HashMap hashMap2 = new HashMap();
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            n = (Integer)object2.next();
            list2 = (List)hashMap.get(new Integer(n));
            Collections.sort(list2, new MapRecodeComparator());
            MapRecode mapRecode = null;
            for (int i = 0; i < list2.size(); ++i) {
                ArrayList<Object> arrayList2;
                Object object3;
                MapRecode mapRecode2 = (MapRecode)list2.get(i);
                if (mapRecode2.isGap()) {
                    mapRecode = mapRecode2;
                    if (i == list2.size() - 1) {
                        object3 = new ContigGap();
                        ((ContigGap)object3).setGapMapRecode(mapRecode2);
                        arrayList2 = (List)hashMap2.get(new Integer(n));
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<Object>();
                            hashMap2.put(new Integer(n), arrayList2);
                        }
                        arrayList2.add(object3);
                        continue;
                    }
                    mapRecode = mapRecode2;
                    continue;
                }
                if (!mapRecode2.isContig()) continue;
                object3 = mapRecode;
                if (object3 == null) {
                    object3 = MapRecode.createGapMapRecode();
                }
                arrayList2 = new ContigGap();
                ((ContigGap)((Object)arrayList2)).setGapMapRecode((MapRecode)object3);
                ((ContigGap)((Object)arrayList2)).setContigMapRecode(mapRecode2);
                ArrayList<ArrayList<Object>> arrayList3 = (ArrayList<ArrayList<Object>>)hashMap2.get(new Integer(n));
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<ArrayList<Object>>();
                    hashMap2.put(new Integer(n), arrayList3);
                }
                arrayList3.add(arrayList2);
            }
        }
        return hashMap2;
    }

    public static List removeGap(List list) {
        ArrayList<MapRecode> arrayList = new ArrayList<MapRecode>();
        for (MapRecode mapRecode : list) {
            System.err.println("isContig=" + mapRecode.isContig() + " " + mapRecode.getContig());
            if (!mapRecode.isContig()) continue;
            arrayList.add(mapRecode);
        }
        return arrayList;
    }

    public static List convertMapRecodeList(List list) {
        ArrayList<MapRecode> arrayList = new ArrayList<MapRecode>();
        int n = 0;
        for (ContigGap contigGap : list) {
            arrayList.add(contigGap.getGapMapRecode());
            if (contigGap.isExistContig()) {
                arrayList.add(contigGap.getContigMapRecode());
            }
            ++n;
        }
        return arrayList;
    }

    public static List getProjectMapRecodeList(String string, String string2) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        String string3 = DataManager.getProjectMappingFilepath(project, string2);
        return MapFacade.getMapRecodeListCore(string, string3);
    }

    private static List getMapRecodeListCore(String string, String string2) throws IOException {
        if (!new File(string2).isFile()) {
            return new ArrayList();
        }
        MapImporter mapImporter = new MapImporter(string, string2);
        mapImporter.execute();
        return mapImporter.getMapRecodeList();
    }

    public static void saveMapRecode(MapConf mapConf, List list) throws Exception {
        Object object4;
        Object object22;
        List list2 = MapFacade.getMapConfList();
        Object object3 = null;
        for (Object object22 : list2) {
            if (!((MapConf)object22).equalsMapName(mapConf.getName())) continue;
            object3 = object22;
            break;
        }
        Project project = ProjectAccesser.getSelectedProject();
        if (object3 != null) {
            list2.remove(object3);
            object22 = DataManager.getProjectMappingFilepath(project, ((MapConf)object3).getFilename());
            new File((String)object22).delete();
        }
        for (Object object4 : list2) {
            ((MapConf)object4).setSelected(false);
        }
        mapConf.setSelected(true);
        list2.add(mapConf);
        Collections.sort(list2, new MapConfComparator());
        MapFacade.saveMapConf(list2);
        object22 = DataManager.getProjectMappingFilepath(project, mapConf.getFilename());
        object4 = new MapExporter((String)object22, list);
        ((FileExporter)object4).execute();
    }

    public static void saveMapConf(List list) throws IOException {
        String string = DataManager.getMapConfFilepath();
        MapConfExporter mapConfExporter = new MapConfExporter(string, list);
        mapConfExporter.execute();
    }

    public static List getContigList(String string) throws IOException {
        String string2 = DataManager.getContigFilePath(string);
        if (!new File(string2).isFile()) {
            return new ArrayList();
        }
        ContigImporter contigImporter = new ContigImporter(string);
        contigImporter.execute();
        return contigImporter.getContigList();
    }

    public static List createContigGapList(List list) {
        ArrayList<ContigGap> arrayList = new ArrayList<ContigGap>();
        for (MapRecode mapRecode : list) {
            if (!mapRecode.isContig()) continue;
            ContigGap contigGap = new ContigGap();
            contigGap.setContigMapRecode(mapRecode);
            contigGap.setGapLength(100);
            arrayList.add(contigGap);
        }
        return arrayList;
    }

    public static List getMapConfList() {
        return MapFacade.getMapConfList(null);
    }

    public static List getMapConfList(String string) {
        String string2 = DataManager.getMapConfFilepath();
        if (!new File(string2).isFile()) {
            return new ArrayList();
        }
        try {
            ArrayList<MapConf> arrayList;
            MapConfImporter mapConfImporter = new MapConfImporter(string2);
            mapConfImporter.execute();
            ArrayList<MapConf> arrayList2 = mapConfImporter.getMapConfList();
            if (!StringTool.isNull(string)) {
                arrayList = new ArrayList<MapConf>();
                for (MapConf mapConf : arrayList2) {
                    if (!mapConf.equalsOrganism(string)) continue;
                    arrayList.add(mapConf);
                }
            } else {
                arrayList = arrayList2;
            }
            return arrayList;
        }
        catch (IOException iOException) {
            return new ArrayList();
        }
    }

    public static int getBaseChromId() {
        try {
            Object object;
            if (!new File(Const.USER_CHROM_ID_PATH).isFile()) {
                object = new ChromosomeIdExporter(-1);
                ((FileExporter)object).execute();
            }
            object = new ChromosomeIdImporter();
            ((FileImporter)object).execute();
            int n = ((ChromosomeIdImporter)object).getChromId();
            return n;
        }
        catch (IOException iOException) {
            logger.warn("Fail to load base chromosome id.", iOException);
            return 1;
        }
    }

    public static void saveBaseChromId(int n) {
        try {
            ChromosomeIdExporter chromosomeIdExporter = new ChromosomeIdExporter(n);
            chromosomeIdExporter.execute();
        }
        catch (IOException iOException) {
            logger.warn("Fail to save base chromosome id.", iOException);
        }
    }

    public static List createChromosomeList(String string, Map map, String string2) {
        Object object;
        Object object22;
        List list = MapFacade.getChromosomeNoList(map);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ChromosomeTbl chromosomeTbl = new ChromosomeTbl(string);
        try {
            chromosomeTbl.readServerOnly();
            for (Object object22 : chromosomeTbl.values()) {
                hashMap.put(((Chromosome)object22).getName(), object22);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap hashMap2 = new HashMap();
        if (!StringTool.isNull(string2)) {
            try {
                object22 = MapFacade.getProjectMapRecodeList(string, string2);
                object = object22.iterator();
                while (object.hasNext()) {
                    MapRecode mapRecode = (MapRecode)object.next();
                    hashMap2.put(mapRecode.getChrNo(), mapRecode.getChromosome());
                }
            }
            catch (IOException iOException) {
                logger.warn("Fail to load mapping file. " + string + string2, iOException);
            }
        }
        object22 = MapFacade.getSpId(string);
        object = new ArrayList();
        int n = MapFacade.getBaseChromId();
        int n2 = 1;
        for (String string3 : list) {
            Chromosome chromosome;
            if (hashMap2.get(string3) != null) {
                chromosome = (Chromosome)hashMap2.get(string3);
            } else {
                ContigGapGroup contigGapGroup = (ContigGapGroup)map.get(string3);
                chromosome = MapFacade.createChromosome(n, string3, (String)object22, string, n2, contigGapGroup);
                --n;
                ++n2;
                Chromosome chromosome2 = (Chromosome)hashMap.get(string3);
                if (chromosome2 != null) {
                    chromosome.setAccession(chromosome2.getAccession());
                    chromosome.setGi(chromosome2.getGi());
                    chromosome.setSeq(chromosome2.getSeq());
                    chromosome.setShape(chromosome2.getShape());
                    chromosome.setGenome(chromosome2.getGenome());
                    chromosome.setStatus(chromosome2.getStatus());
                }
            }
            object.add(chromosome);
        }
        return object;
    }

    public static List getChromosomeNoList(Map map) {
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList, new ChromosomeNoComparator());
        return arrayList;
    }

    private static Chromosome createChromosome(int n, String string, String string2, String string3, int n2, ContigGapGroup contigGapGroup) {
        Chromosome chromosome = new Chromosome();
        chromosome.setId(n);
        chromosome.setSpid(string2);
        chromosome.setOrganismCode(string3);
        chromosome.setName(contigGapGroup.getChrNo());
        chromosome.setSeqNo(String.valueOf(n2));
        chromosome.setType("chromosome");
        chromosome.setShape(contigGapGroup.getShape());
        chromosome.setAccession("");
        chromosome.setGi("");
        chromosome.setSeq("-1");
        chromosome.setSeqLength(contigGapGroup.getLength());
        chromosome.setCountGene(0);
        chromosome.setLength(contigGapGroup.getLength());
        return chromosome;
    }

    private static String getSpId(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        GenomeTbl genomeTbl = new GenomeTbl();
        genomeTbl.read(hashSet);
        List list = genomeTbl.getGenomeList();
        if (CollectionUtil.isNull(list)) {
            return "gu99999";
        }
        Genome genome = (Genome)list.get(0);
        return genome.getSpeciesID();
    }

    public static Set getChrIdSetFromMappingFile(String string, String string2) {
        List list = MapFacade.getMapConfList(string);
        HashSet hashSet = new HashSet();
        for (MapConf mapConf : list) {
            if (mapConf.getFilename().equals(string2)) continue;
            try {
                List list2 = MapFacade.getProjectMapRecodeList(string, mapConf.getFilename());
                hashSet.addAll(MapFacade.getChromIdSetFromMapRecode(list2));
            }
            catch (Exception exception) {
                logger.warn("Fail to load mapping file. " + string + " " + mapConf.getFilename(), exception);
            }
        }
        return hashSet;
    }

    private static Set getChromIdSetFromMapRecode(List list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (MapRecode mapRecode : list) {
            hashSet.add(new Integer(mapRecode.getChrId()));
        }
        return hashSet;
    }

    public static Set getChromIdSetFromChromosome(List list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Chromosome chromosome : list) {
            hashSet.add(new Integer(chromosome.getId()));
        }
        return hashSet;
    }

    public static Set getContigIdSetFromMapRecode(List list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (MapRecode mapRecode : list) {
            Contig contig = mapRecode.getContig();
            if (contig == null) continue;
            hashSet.add(new Integer(contig.getId()));
        }
        return hashSet;
    }

    public static List createMapRecodeFromContig(Collection collection, Set set) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, new ContigComparator());
        ArrayList<MapRecode> arrayList2 = new ArrayList<MapRecode>();
        int n = 0;
        for (Contig contig : arrayList) {
            if (set.contains(new Integer(contig.getId())) || !contig.isContig()) continue;
            MapRecode mapRecode = new MapRecode();
            mapRecode.setContig(contig);
            mapRecode.setTo(contig.getLength());
            mapRecode.setFrom(1);
            mapRecode.setDirection((short)0);
            arrayList2.add(mapRecode);
            if (n < 10) {
                System.err.println("MAPRECODE:" + mapRecode + " >>>" + arrayList2.get(0));
            }
            ++n;
        }
        System.err.println("MAPRECODE0:" + arrayList2.get(0));
        return arrayList2;
    }

    public static void setSelectedMapConf(MapConf mapConf) {
        MAP_MANAGER.setSelectMapConf(mapConf);
    }

    public static MapConf getSelectedMapConf(String string) {
        return MAP_MANAGER.getSelectMapConf(string);
    }

    public static boolean isSelectedMapConf(MapConf mapConf) {
        MapConf mapConf2 = MAP_MANAGER.getSelectMapConf(mapConf.getOrganismCode());
        if (mapConf2 == null) {
            return false;
        }
        return mapConf2.equalsMapName(mapConf.getName());
    }

    public static void selectMapping(MapConf mapConf) throws IOException {
        MAP_MANAGER.setSelectMapConf(mapConf);
        List list = MapFacade.getMapConfList();
        for (MapConf mapConf2 : list) {
            mapConf2.setSelected(mapConf2.equalsMapName(mapConf.getName()));
        }
        MapFacade.saveMapConf(list);
    }

    public static void upateMappingSelectState() {
        MAP_MANAGER.updateSelectMapConfMap();
    }

    private static Set getMapNameSet(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (MapConf mapConf : collection) {
            hashSet.add(mapConf.getName());
        }
        return hashSet;
    }

    public static void deleteMapConf(Collection collection) throws IOException {
        Project project = ProjectAccesser.getSelectedProject();
        Set set = MapFacade.getMapNameSet(collection);
        List list = MapFacade.getMapConfList();
        HashSet<MapConf> hashSet = new HashSet<MapConf>();
        for (MapConf mapConf : list) {
            if (!set.contains(mapConf.getName())) continue;
            hashSet.add(mapConf);
        }
        list.removeAll(hashSet);
        MapFacade.saveMapConf(list);
        for (MapConf mapConf : collection) {
            String string = DataManager.getProjectMappingFilepath(project, mapConf.getFilename());
            FileUtil.delete(string);
        }
    }

    public static void saveDefaultMap(Set set) throws IOException {
        DefaultMapCreater defaultMapCreater = new DefaultMapCreater(set);
        defaultMapCreater.execute();
    }

    public static Map createContigGapGroupMap(List list, String string) throws Exception {
        Map map = MapFacade.createContigGapListMap(list);
        HashMap<String, ContigGapGroup> hashMap = new HashMap<String, ContigGapGroup>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            List list2 = (List)map.get(new Integer(n));
            if (CollectionUtil.isNull(list2)) continue;
            ContigGap contigGap = (ContigGap)list2.get(0);
            Chromosome chromosome = contigGap.getContigMapRecode().getChromosome();
            ContigGapGroup contigGapGroup = new ContigGapGroup();
            String string2 = "<None Assign>";
            if (!CollectionUtil.isNull(list2)) {
                ContigGap contigGap2 = (ContigGap)list2.get(list2.size() - 1);
                if (!contigGap2.isExistContig()) {
                    contigGapGroup.setEndGap(contigGap2);
                    list2.remove(list2.size() - 1);
                } else {
                    contigGapGroup.getEndGap().setChromosome(contigGap2.getChromosome());
                }
                contigGapGroup.setContigGapList(list2);
            }
            if (chromosome != null) {
                string2 = chromosome.getName();
                contigGapGroup.setChrNo(string2);
                contigGapGroup.setShape(chromosome.getShape());
            }
            hashMap.put(string2, contigGapGroup);
        }
        return hashMap;
    }
}

