/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.menu;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.AminoCode;
import cgdp.recog.data.AminoCodeTbl;
import cgdp.recog.table.AminoCodeCellRenderer;
import cgdp.recog.table.AminoCodeTableModel;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JColorChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class AminoCodeTable
extends JScrollPane
implements MouseListener {
    MediatorImpl m_mediatorImpl;
    AminoCodeTbl m_aminoCodeTbl;
    int m_width;
    JTable m_table;

    public AminoCodeTable(MediatorImpl mediatorImpl) {
        this.m_mediatorImpl = mediatorImpl;
        this.clear();
        this.createComponent();
        this.setPreferredSize(new Dimension(this.m_width + 20, 320));
        this.setHorizontalScrollBarPolicy(31);
    }

    private void clear() {
        this.m_aminoCodeTbl = AminoCodeTbl.getInstance();
        this.m_width = 0;
    }

    private void createComponent() {
        Object object;
        int[] nArray = new int[]{30, 50, 100, 80};
        Object[] objectArray = new String[]{" ", " ", " ", "Color"};
        Object[][] objectArray2 = new Object[this.m_aminoCodeTbl.size()][4];
        Iterator iterator = this.m_aminoCodeTbl.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (AminoCode)this.m_aminoCodeTbl.get(string);
            objectArray2[n][0] = ((AminoCode)object).getCode();
            objectArray2[n][1] = ((AminoCode)object).getCode3();
            objectArray2[n][2] = ((AminoCode)object).getCodeFull();
            objectArray2[n][3] = ((AminoCode)object).getColor();
            ++n;
        }
        this.m_table = new JTable(new AminoCodeTableModel(objectArray2, objectArray));
        this.m_table.addMouseListener(this);
        this.m_table.setSelectionMode(0);
        this.m_table.setRowHeight(20);
        Enumeration<TableColumn> enumeration = this.m_table.getColumnModel().getColumns();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((TableColumn)object).setPreferredWidth(nArray[n2]);
            if (n2 == 3) {
                ((TableColumn)object).setCellRenderer(new AminoCodeCellRenderer());
            }
            this.m_width += nArray[n2];
            ++n2;
        }
        this.setViewportView(this.m_table);
    }

    private void setAminoCodeColor(int n) {
        String string = (String)this.m_table.getValueAt(n, 0);
        String string2 = (String)this.m_table.getValueAt(n, 3);
        Color color = JColorChooser.showDialog(this.m_table, "Color palette", ColorUtil.str2Color(string2));
        if (color != null) {
            this.m_table.setValueAt(ColorUtil.color2Str(color), n, 3);
            this.m_table.repaint();
        }
    }

    public void setAminoCodeColor() {
        int n = this.m_table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.m_table.getValueAt(i, 0);
            String string2 = (String)this.m_table.getValueAt(i, 3);
            ((AminoCode)this.m_aminoCodeTbl.get(string)).setColor(string2);
        }
    }

    public void restoreAminoCodeColor() {
        int n = this.m_table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.m_table.getValueAt(i, 0);
            AminoCode aminoCode = (AminoCode)this.m_aminoCodeTbl.get(string);
            this.m_table.setValueAt(aminoCode.getColor(), i, 3);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.m_table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.m_table.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 == 3 && mouseEvent.getButton() == 1) {
            this.setAminoCodeColor(n);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

