/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.mgmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.mgmap.AlignmentColorSettingTool;
import cgdp.recog.mgmap.AlignmentListColorDialog;
import cgdp.recog.mgmap.AlignmentMap;
import cgdp.recog.mgmap.AlignmentScrollPane;
import cgdp.recog.mgmap.LabelOnOffTool;
import cgdp.recog.mgmap.RGMCondition;
import cgdp.recog.mgmap.ZoomInTool;
import cgdp.recog.mgmap.ZoomOutTool;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class AlignmentFrame
extends ApplicationFrame
implements ActionListener {
    private MediatorImpl mediator;
    private AlignmentMap alignmentMap;
    private AlignmentScrollPane alignmentScrollPane;
    private LabelOnOffTool labelOnOffTool;
    private RGMCondition rgmCondition = new RGMCondition();

    public AlignmentFrame(JFrame jFrame, MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.setTitle("Alignment List");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AlignmentFrame.this.mediator.closeAlignmentFrame();
            }
        });
        this.createToolBar();
        this.createComponent();
        this.pack();
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        if (optionValues.getAlignmentFrameW() != 0 && optionValues.getAlignmentFrameH() != 0) {
            this.setBounds(optionValues.getAlignmentFrameX(), optionValues.getAlignmentFrameY(), optionValues.getAlignmentFrameW(), optionValues.getAlignmentFrameH());
            this.validate();
        } else {
            this.setLocationRelativeTo(null);
        }
    }

    private void createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.getContentPane().add((Component)jToolBar, "North");
        this.labelOnOffTool = new LabelOnOffTool(this, this);
        jToolBar.add(this.labelOnOffTool);
        jToolBar.addSeparator();
        jToolBar.add(new ZoomInTool(this, this));
        jToolBar.add(new ZoomOutTool(this, this));
        jToolBar.addSeparator();
        jToolBar.add(new AlignmentColorSettingTool(this, this));
    }

    private void createComponent() {
        this.alignmentMap = new AlignmentMap(this.mediator);
        this.alignmentMap.setRGMCondition(this.rgmCondition);
        this.alignmentScrollPane = new AlignmentScrollPane(this, this.alignmentMap);
        this.getContentPane().add((Component)this.alignmentScrollPane, "Center");
    }

    public void updateValue(String string) {
        this.updateCondtion(string);
        this.alignmentMap.updateValue(this.rgmCondition);
        this.labelOnOffTool.updateValue(this.rgmCondition);
    }

    private void updateCondtion(String string) {
        this.rgmCondition.setDomClustId(string);
        ApplicationPropertyFacade.updateDomClustAccessable(string, this.rgmCondition);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    public void clear() {
        this.alignmentMap.clear();
    }

    public void zoomIn() {
        this.alignmentMap.zoomIn();
    }

    public void zoomOut() {
        this.alignmentMap.zoomOut();
    }

    public void labelOnOff(boolean bl) {
        this.alignmentMap.labelOnOff(bl);
    }

    public void showColorDialog() {
        AlignmentListColorDialog alignmentListColorDialog = new AlignmentListColorDialog((Frame)this, this.mediator, this.rgmCondition);
        alignmentListColorDialog.setVisible(true);
        alignmentListColorDialog.dispose();
    }

    public void createGeneClassMap() {
        this.alignmentMap.createGeneClassMap();
    }

    public void setProgressImpl(ProgressImpl progressImpl) {
        this.alignmentMap.setProgressImpl(progressImpl);
    }

    public void setGeneInfoList(Collection collection) {
        this.alignmentMap.setGeneInfoC(collection);
    }

    public int getViewCount() {
        return this.alignmentMap.getViewCount();
    }

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.alignmentMap.setClusterTbl(clusterTbl);
    }

    public void createAlignmentMap() {
        this.alignmentMap.createAlignmentMap(this.alignmentScrollPane.getSize());
    }

    public void resizeAlignmentMap() {
        if (this.isVisible()) {
            this.mediator.drawFeatureMap2();
        }
    }
}

