/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.neighbor;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.neighbor.NeighboringClustCondition;
import cgdp.recog.neighbor.NeighboringClustExecuter;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class NeighborClustGeneSortExecuter
extends AbstractThreadProcess {
    private static ApplicationLogger logger = new ApplicationLogger(NeighborClustGeneSortExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private NeighboringClustCondition condition;
    private boolean recalc = false;
    private Map geneInfoGroupIdMap = new HashMap();

    public NeighborClustGeneSortExecuter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, NeighboringClustCondition neighboringClustCondition) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.condition = neighboringClustCondition;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            NeighboringClustExecuter neighboringClustExecuter = new NeighboringClustExecuter(this.condition, this.clusterTbl.getViewClusterList(), this.clusterTbl.getViewOrganismCodeList());
            neighboringClustExecuter.execute(progressImpl);
            this.geneInfoGroupIdMap = neighboringClustExecuter.getGeneInfoGroupIdMap();
        }
        catch (Exception exception) {
            String string = "Fail to execute neighborhood clusters.";
            this.setError(true);
            this.setErrorMessage(string);
            logger.warn(string, exception);
        }
    }

    public void done() {
        if (this.isError()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageManager.showErrorMessage(NeighborClustGeneSortExecuter.this.parent, NeighborClustGeneSortExecuter.this.getErrorMessages());
                }
            });
            return;
        }
        this.mediator.updateForNeighboringCluster(this.condition, this.geneInfoGroupIdMap, this.isRecalc());
    }

    public void setRecalc(boolean bl) {
        this.recalc = bl;
    }

    public boolean isRecalc() {
        return this.recalc;
    }
}

