/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.multiplealign.ClustalWOption;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValidator;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.FileSelectPanel;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class MultipleAlignOptionPanel
extends TabPanel
implements ActionListener {
    private static final int MARGIN_HORIZ_GUI = 7;
    private MediatorImpl mediator;
    private FileSelectPanel cmdSelectPanel;
    private JComboBox typeComboBox;
    private JComboBox outputComboBox;
    private JComboBox outorderComboBox;
    private JComboBox matrixComboBox;
    private JComboBox seqnoRangeComboBox;
    private RestrictTextField seqnoStartTextField;
    private RestrictTextField seqnoLengthTextField;
    private RestrictTextField gapOpenTextField;
    private RestrictTextField gapExtTextField;
    private RestrictTextField gapDistTextField;
    private RestrictTextField maxDivTextField;
    private JComboBox endGapsComboBox;
    private JComboBox noPGapComboBox;
    private JComboBox noHGapComboBox;
    private JRadioButton quickTreeOnButton;
    private JRadioButton quickTreeOffButton;
    private RestrictTextField ktupleTextField;
    private RestrictTextField windowTextField;
    private JComboBox scoreComboBox;
    private RestrictTextField topDiagsTextField;
    private RestrictTextField pairGapTextField;
    private JComboBox pwDnaMatrixComboBox;
    private RestrictTextField pwGapOpenTextField;
    private RestrictTextField pwGapExtTextField;

    MultipleAlignOptionPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.createTypePane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 3, 7), 0, 0));
        jPanel.add((Component)this.createLine1Panel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 3, 7), 0, 0));
        jPanel.add((Component)this.createLine2Panel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 3, 7), 0, 0));
        jPanel.add((Component)this.createQuickTreePanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 3, 7), 0, 0));
        jPanel.add((Component)this.createLine3Panel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 3, 7), 0, 0));
        jPanel.add((Component)this.createLine4Panel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 3, 10), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createCmdPathPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.initValue();
    }

    private JPanel createCmdPathPanel() {
        JLabel jLabel = new JLabel("Path");
        this.cmdSelectPanel = new FileSelectPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.cmdSelectPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createTypePane() {
        JLabel jLabel = new JLabel("TYPE");
        this.typeComboBox = new JComboBox<String>(ClustalWOption.TYPES);
        this.typeComboBox.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.typeComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createLine1Panel() {
        JLabel jLabel = new JLabel("OUTPUT");
        this.outputComboBox = new JComboBox<String>(ClustalWOption.OUTPUTS);
        JLabel jLabel2 = new JLabel("OUTORDER");
        this.outorderComboBox = new JComboBox<String>(ClustalWOption.OUTORDERS);
        JLabel jLabel3 = new JLabel("MATRIX");
        this.matrixComboBox = new JComboBox<String>(ClustalWOption.MATRIXS);
        JLabel jLabel4 = new JLabel("SEQNO RANGE");
        this.seqnoRangeComboBox = new JComboBox<String>(ClustalWOption.ONOFF);
        this.seqnoRangeComboBox.addActionListener(this);
        JLabel jLabel5 = new JLabel("START");
        this.seqnoStartTextField = new RestrictTextField(10);
        JLabel jLabel6 = new JLabel("LENGTH");
        this.seqnoLengthTextField = new RestrictTextField(10);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(3, 0, 5, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)this.outputComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.outorderComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.matrixComboBox, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.seqnoRangeComboBox, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)jLabel5, new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.seqnoStartTextField, new GridBagConstraints(5, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)jLabel6, new GridBagConstraints(6, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.seqnoLengthTextField, new GridBagConstraints(7, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        return jPanel;
    }

    private JPanel createLine2Panel() {
        JLabel jLabel = new JLabel("GAPOPEN");
        this.gapOpenTextField = new RestrictTextField(10);
        this.gapOpenTextField.setDecimal(true);
        JLabel jLabel2 = new JLabel("GAPEXT");
        this.gapExtTextField = new RestrictTextField(10);
        this.gapExtTextField.setDecimal(true);
        JLabel jLabel3 = new JLabel("GAPDIST");
        this.gapDistTextField = new RestrictTextField(10);
        JLabel jLabel4 = new JLabel("MAXDIV");
        this.maxDivTextField = new RestrictTextField(10);
        JLabel jLabel5 = new JLabel("ENDGAPS");
        this.endGapsComboBox = new JComboBox<String>(ClustalWOption.ONOFF);
        JLabel jLabel6 = new JLabel("NOPGAP");
        this.noPGapComboBox = new JComboBox<String>(ClustalWOption.ONOFF);
        JLabel jLabel7 = new JLabel("NOHGAP");
        this.noHGapComboBox = new JComboBox<String>(ClustalWOption.ONOFF);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel5, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel6, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel7, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)this.gapOpenTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.gapExtTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.gapDistTextField, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.maxDivTextField, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.endGapsComboBox, new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.noPGapComboBox, new GridBagConstraints(5, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.noHGapComboBox, new GridBagConstraints(6, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        return jPanel;
    }

    private JPanel createQuickTreePanel() {
        JLabel jLabel = new JLabel("QUICKTREE");
        this.quickTreeOnButton = new JRadioButton("ON");
        this.quickTreeOffButton = new JRadioButton("OFF");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.quickTreeOnButton);
        buttonGroup.add(this.quickTreeOffButton);
        this.quickTreeOnButton.addActionListener(this);
        this.quickTreeOffButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.quickTreeOnButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.quickTreeOffButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 7), 0, 0));
        return jPanel;
    }

    private JPanel createLine3Panel() {
        JLabel jLabel = new JLabel("KTUPLE");
        this.ktupleTextField = new RestrictTextField(10);
        JLabel jLabel2 = new JLabel("WINDOW");
        this.windowTextField = new RestrictTextField(10);
        JLabel jLabel3 = new JLabel("SCORE");
        this.scoreComboBox = new JComboBox<String>(ClustalWOption.SCORES);
        JLabel jLabel4 = new JLabel("TOPDIAGS");
        this.topDiagsTextField = new RestrictTextField(10);
        JLabel jLabel5 = new JLabel("PAIRGAP");
        this.pairGapTextField = new RestrictTextField(10);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel5, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)this.ktupleTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.windowTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.scoreComboBox, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.topDiagsTextField, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.pairGapTextField, new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        return jPanel;
    }

    private JPanel createLine4Panel() {
        JLabel jLabel = new JLabel("PWDNAMATRIX");
        this.pwDnaMatrixComboBox = new JComboBox<String>(ClustalWOption.PWDNAMATRIXS);
        JLabel jLabel2 = new JLabel("PWGAPOPEN");
        this.pwGapOpenTextField = new RestrictTextField(10);
        this.pwGapOpenTextField.setDecimal(true);
        JLabel jLabel3 = new JLabel("PWGAPEXT");
        this.pwGapExtTextField = new RestrictTextField();
        this.pwGapExtTextField.setDecimal(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 7), 0, 0));
        jPanel.add((Component)this.pwDnaMatrixComboBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.pwGapOpenTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        jPanel.add((Component)this.pwGapExtTextField, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 7), 0, 0));
        return jPanel;
    }

    private void initValue() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        String string = optionValues.getClustalW();
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        String string2 = new File(optionValues.getClustalW()).getAbsolutePath();
        this.cmdSelectPanel.setDefaultPath(string2);
        this.typeComboBox.setSelectedItem(optionValues.getClustalWOpt_TYPE());
        this.outputComboBox.setSelectedItem(optionValues.getClustalWOpt_OUTPUT());
        this.outorderComboBox.setSelectedItem(optionValues.getClustalWOpt_ORDER());
        this.matrixComboBox.setSelectedItem(optionValues.getClustalWOpt_MATRIX());
        this.seqnoRangeComboBox.setSelectedItem(optionValues.getClustalWOpt_RANGE());
        this.seqnoStartTextField.setText(String.valueOf(optionValues.getClustalWOpt_START()));
        this.seqnoLengthTextField.setText(String.valueOf(optionValues.getClustalWOpt_LENGTH()));
        this.gapOpenTextField.setText(String.valueOf(optionValues.getClustalWOpt_OPEN()));
        this.gapExtTextField.setText(String.valueOf(optionValues.getClustalWOpt_EXT()));
        this.gapDistTextField.setText(String.valueOf(optionValues.getClustalWOpt_DIST()));
        this.maxDivTextField.setText(String.valueOf(optionValues.getClustalWOpt_DIV()));
        this.endGapsComboBox.setSelectedItem(optionValues.getClustalWOpt_END());
        this.noPGapComboBox.setSelectedItem(optionValues.getClustalWOpt_NOP());
        this.noHGapComboBox.setSelectedItem(optionValues.getClustalWOpt_NOH());
        this.quickTreeOnButton.setSelected(optionValues.isClustalWQuickTree());
        this.quickTreeOffButton.setSelected(!optionValues.isClustalWQuickTree());
        this.ktupleTextField.setText(String.valueOf(optionValues.getClustalWOpt_KTUPLE()));
        this.windowTextField.setText(String.valueOf(optionValues.getClustalWOpt_WINDOW()));
        this.scoreComboBox.setSelectedItem(optionValues.getClustalWOpt_SCORE());
        this.topDiagsTextField.setText(String.valueOf(optionValues.getClustalWOpt_TOP()));
        this.pairGapTextField.setText(String.valueOf(optionValues.getClustalWOpt_PAIR()));
        this.pwDnaMatrixComboBox.setSelectedItem(optionValues.getClustalWOpt_PWM());
        this.pwGapOpenTextField.setText(String.valueOf(optionValues.getClustalWOpt_PWO()));
        this.pwGapExtTextField.setText(String.valueOf(optionValues.getClustalWOpt_PWE()));
        this.setEnabledGUIByType();
    }

    private String getType() {
        return (String)this.typeComboBox.getSelectedItem();
    }

    private boolean isUseDefault() {
        return ClustalWOption.isUseDefualt(this.getType());
    }

    private String getSeqNoRange() {
        return (String)this.seqnoRangeComboBox.getSelectedItem();
    }

    private boolean isSeqNoRangeOn() {
        return ClustalWOption.isOn(this.getSeqNoRange());
    }

    private boolean isQuickTreeOn() {
        return this.quickTreeOnButton.isSelected();
    }

    private String getCmdPath() {
        return this.cmdSelectPanel.getPath();
    }

    private String getOutput() {
        return (String)this.outputComboBox.getSelectedItem();
    }

    private String getOutorder() {
        return (String)this.outorderComboBox.getSelectedItem();
    }

    private String getMatrix() {
        return (String)this.matrixComboBox.getSelectedItem();
    }

    private int getSeqNoStart() {
        if (this.isSeqNoRangeOn()) {
            return Integer.parseInt(this.seqnoStartTextField.getText());
        }
        return OptionTbl.getInstance().getOptionValues().getClustalWOpt_START();
    }

    private int getSeqNoLength() {
        if (this.isSeqNoRangeOn()) {
            return Integer.parseInt(this.seqnoLengthTextField.getText());
        }
        return OptionTbl.getInstance().getOptionValues().getClustalWOpt_LENGTH();
    }

    private double getGapOpen() {
        return Double.parseDouble(this.gapOpenTextField.getText());
    }

    private double getGapExt() {
        return Double.parseDouble(this.gapExtTextField.getText());
    }

    private int getGapDist() {
        return Integer.parseInt(this.gapDistTextField.getText());
    }

    private int getMaxdiv() {
        return Integer.parseInt(this.maxDivTextField.getText());
    }

    private String getEndGap() {
        return (String)this.endGapsComboBox.getSelectedItem();
    }

    private String getNoPGap() {
        return (String)this.noPGapComboBox.getSelectedItem();
    }

    private String getNoHGap() {
        return (String)this.noHGapComboBox.getSelectedItem();
    }

    private String getQuickTree() {
        return this.quickTreeOnButton.isSelected() ? "ON" : "OFF";
    }

    private int getKtuple() {
        if (this.isQuickTreeOn()) {
            return Integer.parseInt(this.ktupleTextField.getText());
        }
        return OptionTbl.getInstance().getOptionValues().getClustalWOpt_KTUPLE();
    }

    private int getWindow() {
        if (this.isQuickTreeOn()) {
            return Integer.parseInt(this.windowTextField.getText());
        }
        return OptionTbl.getInstance().getOptionValues().getClustalWOpt_WINDOW();
    }

    private String getScore() {
        if (this.isQuickTreeOn()) {
            return (String)this.scoreComboBox.getSelectedItem();
        }
        return OptionTbl.getInstance().getOptionValues().getClustalWOpt_SCORE();
    }

    private int getTopDiags() {
        if (this.isQuickTreeOn()) {
            return Integer.parseInt(this.topDiagsTextField.getText());
        }
        return OptionTbl.getInstance().getOptionValues().getClustalWOpt_TOP();
    }

    private int getPairGap() {
        if (this.isQuickTreeOn()) {
            return Integer.parseInt(this.pairGapTextField.getText());
        }
        return OptionTbl.getInstance().getOptionValues().getClustalWOpt_PAIR();
    }

    private String getPwDnaMatrix() {
        if (this.isQuickTreeOn()) {
            return OptionTbl.getInstance().getOptionValues().getClustalWOpt_PWM();
        }
        return (String)this.pwDnaMatrixComboBox.getSelectedItem();
    }

    private double getPwGapOpen() {
        if (this.isQuickTreeOn()) {
            return OptionTbl.getInstance().getOptionValues().getClustalWOpt_PWO();
        }
        return Double.parseDouble(this.pwGapOpenTextField.getText());
    }

    private double getPwGapExt() {
        if (this.isQuickTreeOn()) {
            return OptionTbl.getInstance().getOptionValues().getClustalWOpt_PWE();
        }
        return Double.parseDouble(this.pwGapExtTextField.getText());
    }

    private void setEnabledGUIByType() {
        if (this.isUseDefault()) {
            this.setEnebledGUI(false);
        } else {
            this.setEnebledGUI(true);
            this.setEnabledSeqNoRange();
            this.setEnabledQuickTree();
        }
    }

    private void setEnabledSeqNoRange() {
        if (this.isSeqNoRangeOn()) {
            this.seqnoStartTextField.setEditable(true);
            this.seqnoLengthTextField.setEditable(true);
        } else {
            this.seqnoStartTextField.setEditable(false);
            this.seqnoLengthTextField.setEditable(false);
        }
    }

    private void setEnabledQuickTree() {
        if (this.isQuickTreeOn()) {
            this.ktupleTextField.setEditable(true);
            this.windowTextField.setEditable(true);
            this.scoreComboBox.setEnabled(true);
            this.topDiagsTextField.setEditable(true);
            this.pairGapTextField.setEditable(true);
            this.pwDnaMatrixComboBox.setEnabled(false);
            this.pwGapOpenTextField.setEditable(false);
            this.pwGapExtTextField.setEditable(false);
        } else {
            this.ktupleTextField.setEditable(false);
            this.windowTextField.setEditable(false);
            this.scoreComboBox.setEnabled(false);
            this.topDiagsTextField.setEditable(false);
            this.pairGapTextField.setEditable(false);
            this.pwDnaMatrixComboBox.setEnabled(true);
            this.pwGapOpenTextField.setEditable(true);
            this.pwGapExtTextField.setEditable(true);
        }
    }

    private void setEnebledGUI(boolean bl) {
        this.outputComboBox.setEnabled(bl);
        this.outorderComboBox.setEnabled(bl);
        this.matrixComboBox.setEnabled(bl);
        this.seqnoRangeComboBox.setEnabled(bl);
        this.seqnoStartTextField.setEditable(bl);
        this.seqnoLengthTextField.setEditable(bl);
        this.gapOpenTextField.setEditable(bl);
        this.gapExtTextField.setEditable(bl);
        this.gapDistTextField.setEditable(bl);
        this.maxDivTextField.setEditable(bl);
        this.endGapsComboBox.setEnabled(bl);
        this.noPGapComboBox.setEnabled(bl);
        this.noHGapComboBox.setEnabled(bl);
        this.quickTreeOnButton.setEnabled(bl);
        this.quickTreeOffButton.setEnabled(bl);
        this.ktupleTextField.setEditable(bl);
        this.windowTextField.setEditable(bl);
        this.scoreComboBox.setEnabled(bl);
        this.topDiagsTextField.setEditable(bl);
        this.pairGapTextField.setEditable(bl);
        this.pwDnaMatrixComboBox.setEnabled(bl);
        this.pwGapOpenTextField.setEditable(bl);
        this.pwGapExtTextField.setEditable(bl);
    }

    private boolean validateIntValue(JTextField jTextField, String string, int n, int n2) {
        return OptionValidator.validateIntValue(this, jTextField, string, n, n2);
    }

    private boolean validateDoubleValue(JTextField jTextField, String string, double d, double d2) {
        return OptionValidator.validateDoubleValue(this, jTextField, string, d, d2);
    }

    protected void changeDefault() {
        this.typeComboBox.setSelectedItem("Use default");
        this.outputComboBox.setSelectedItem("clustal");
        this.outorderComboBox.setSelectedItem("aligned");
        this.matrixComboBox.setSelectedItem("blosum");
        this.seqnoRangeComboBox.setSelectedItem("OFF");
        this.seqnoStartTextField.setText(String.valueOf(Integer.MIN_VALUE));
        this.seqnoLengthTextField.setText(String.valueOf(Integer.MIN_VALUE));
        this.gapOpenTextField.setText(String.valueOf(10.0));
        this.gapExtTextField.setText(String.valueOf(0.2));
        this.gapDistTextField.setText(String.valueOf(8));
        this.maxDivTextField.setText(String.valueOf(40));
        this.endGapsComboBox.setSelectedItem("OFF");
        this.noHGapComboBox.setSelectedItem("OFF");
        this.noPGapComboBox.setSelectedItem("OFF");
        if (ClustalWOption.isOn("OFF")) {
            this.quickTreeOnButton.setSelected(true);
        } else {
            this.quickTreeOffButton.setSelected(true);
        }
        this.ktupleTextField.setText(String.valueOf("ON"));
        this.windowTextField.setText(String.valueOf(5));
        this.scoreComboBox.setSelectedItem("percent");
        this.topDiagsTextField.setText(String.valueOf(5));
        this.pairGapTextField.setText(String.valueOf(3));
        this.pwDnaMatrixComboBox.setSelectedItem("blosum");
        this.pwGapOpenTextField.setText(String.valueOf(10.0));
        this.pwGapExtTextField.setText(String.valueOf(0.1));
        this.setEnabledGUIByType();
    }

    public boolean check() {
        if (this.isUseDefault()) {
            return true;
        }
        if (this.isSeqNoRangeOn()) {
            if (!this.validateIntValue(this.seqnoStartTextField, "START", 1, Integer.MAX_VALUE)) {
                return false;
            }
            if (!this.validateIntValue(this.seqnoLengthTextField, "LENGTH", 1, Integer.MAX_VALUE)) {
                return false;
            }
        }
        if (!this.validateDoubleValue(this.gapOpenTextField, "GAPOPEN", 0.0, 100.0)) {
            return false;
        }
        if (!this.validateDoubleValue(this.gapExtTextField, "GAPEXT", 0.0, 10.0)) {
            return false;
        }
        if (!this.validateIntValue(this.gapDistTextField, "GAPDIST", 0, 100)) {
            return false;
        }
        if (!this.validateIntValue(this.maxDivTextField, "MAXDIV", 0, 100)) {
            return false;
        }
        if (this.isQuickTreeOn()) {
            if (!this.validateIntValue(this.ktupleTextField, "KTUPLE", 1, 2)) {
                return false;
            }
            if (!this.validateIntValue(this.windowTextField, "WINDOW", 1, 50)) {
                return false;
            }
            if (!this.validateIntValue(this.topDiagsTextField, "TOPDIAGS", 1, 50)) {
                return false;
            }
            if (!this.validateIntValue(this.pairGapTextField, "PAIRGAP", 1, 500)) {
                return false;
            }
        } else {
            if (!this.validateIntValue(this.pairGapTextField, "PAIRGAP", 1, 500)) {
                return false;
            }
            if (!this.validateDoubleValue(this.pwGapOpenTextField, "PWGAPOPEN", 0.0, 100.0)) {
                return false;
            }
            if (!this.validateDoubleValue(this.pwGapExtTextField, "PWGAPEXT", 0.0, 10.0)) {
                return false;
            }
        }
        return true;
    }

    protected void updateParameters() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        optionValues.setClustalWOpt_TYPE(this.getType());
        if (!this.isUseDefault()) {
            optionValues.setClustalWOpt_OUTPUT(this.getOutput());
            optionValues.setClustalWOpt_ORDER(this.getOutorder());
            optionValues.setClustalWOpt_MATRIX(this.getMatrix());
            optionValues.setClustalWOpt_RANGE(this.getSeqNoRange());
            optionValues.setClustalWOpt_START(this.getSeqNoStart());
            optionValues.setClustalWOpt_LENGTH(this.getSeqNoLength());
            optionValues.setClustalWOpt_OPEN(this.getGapOpen());
            optionValues.setClustalWOpt_EXT(this.getGapExt());
            optionValues.setClustalWOpt_DIST(this.getGapDist());
            optionValues.setClustalWOpt_DIV(this.getMaxdiv());
            optionValues.setClustalWOpt_END(this.getEndGap());
            optionValues.setClustalWOpt_NOP(this.getNoPGap());
            optionValues.setClustalWOpt_NOH(this.getNoHGap());
            optionValues.setClustalWOpt_TREE(this.getQuickTree());
            optionValues.setClustalWOpt_KTUPLE(this.getKtuple());
            optionValues.setClustalWOpt_WINDOW(this.getWindow());
            optionValues.setClustalWOpt_SCORE(this.getScore());
            optionValues.setClustalWOpt_TOP(this.getTopDiags());
            optionValues.setClustalWOpt_PAIR(this.getPairGap());
            optionValues.setClustalWOpt_PWM(this.getPwDnaMatrix());
            optionValues.setClustalWOpt_PWO(this.getPwGapOpen());
            optionValues.setClustalWOpt_PWE(this.getPwGapExt());
        }
        optionValues.setClustalW(this.getCmdPath());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.typeComboBox) {
            this.setEnabledGUIByType();
        } else if (actionEvent.getSource() == this.seqnoRangeComboBox) {
            this.setEnabledSeqNoRange();
        } else if (actionEvent.getSource() == this.quickTreeOnButton) {
            this.setEnabledQuickTree();
        } else if (actionEvent.getSource() == this.quickTreeOffButton) {
            this.setEnabledQuickTree();
        }
    }
}

