/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.neighbor.NeighborClustPPMColor;
import cgdp.recog.option.ColorTable;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.TabPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class NeighborOptionPanel
extends TabPanel
implements ActionListener {
    private MediatorImpl mediator;
    private ColorTable colorPatternTable;
    private JButton addButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;

    NeighborOptionPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createColorPatternPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 20, 10), 0, 0));
        this.initValue();
    }

    private JPanel createColorPatternPanel() {
        JLabel jLabel = new JLabel("Color pattern for clustered cells");
        this.colorPatternTable = new ColorTable();
        JScrollPane jScrollPane = new JScrollPane(this.colorPatternTable, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(100, 200));
        this.colorPatternTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                NeighborOptionPanel.this.setButtonEnable();
            }
        });
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(this);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 0, 5, 10), 0, 0));
        jPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 0, 5, 10), 0, 0));
        jPanel.add((Component)this.upButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 0, 5, 10), 0, 0));
        jPanel.add((Component)this.downButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 0, 5, 10), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        return jPanel2;
    }

    private void initValue() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        List list = optionTbl.getOptionValues().getNeighborColorPatternList();
        List list2 = ColorUtil.str2ColorList(list);
        this.colorPatternTable.setColorList(list2);
        this.setButtonEnable();
    }

    private void setButtonEnable() {
        int[] nArray = this.colorPatternTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            this.deleteButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            return;
        }
        this.deleteButton.setEnabled(true);
        this.upButton.setEnabled(nArray[0] != 0);
        this.downButton.setEnabled(nArray[nArray.length - 1] != this.colorPatternTable.getRowCount() - 1);
    }

    protected void changeDefault() {
        this.colorPatternTable.setColorList(NeighborClustPPMColor.getDefaultColorPatternList());
    }

    public boolean check() {
        if (this.colorPatternTable.getRowCount() == 0) {
            MessageManager.showErrorMessage((Component)this.getParent(), "Input color in [Color pattern for clustered cells].");
            return false;
        }
        return true;
    }

    private List getNeighborColorStrPatternList() {
        return ColorUtil.color2StrList(this.colorPatternTable.getColorList());
    }

    protected void updateParameters() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        boolean bl = false;
        if (!optionValues.getNeighborColorPatternList().equals(this.getNeighborColorStrPatternList())) {
            bl = true;
        }
        optionValues.setNeighborColorPatternList(this.getNeighborColorStrPatternList());
        if (bl) {
            this.mediator.updateFromPPMSetting();
        }
    }

    private Color getNextColor() {
        Color color = this.colorPatternTable.getRowCount() == 0 ? (Color)NeighborClustPPMColor.getDefaultColorPatternList().get(0) : (this.colorPatternTable.getRowCount() == 1 ? (Color)this.colorPatternTable.getValueAt(0, 0) : (Color)this.colorPatternTable.getValueAt(this.colorPatternTable.getRowCount() - 2, 0));
        return color;
    }

    private void add() {
        this.colorPatternTable.addColor(this.getNextColor());
    }

    private void delete() {
        this.colorPatternTable.deleteSelectedColors();
    }

    private void up() {
        this.colorPatternTable.upSelectedColors();
    }

    private void down() {
        this.colorPatternTable.downSelectedColors();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            this.add();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.delete();
        } else if (actionEvent.getSource() == this.upButton) {
            this.up();
        } else if (actionEvent.getSource() == this.downButton) {
            this.down();
        }
    }
}

