/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.AuthOptionPanel;
import cgdp.recog.option.GeneralPanel;
import cgdp.recog.option.MultipleAlignOptionPanel;
import cgdp.recog.option.NeighborOptionPanel;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.PhylogeneticPatternOptionPanel;
import cgdp.recog.option.TaxonomyTreeSettingPanel;
import cgdp.recog.option.TreeOptionPanel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.TabDialog;
import java.awt.Component;
import java.awt.Frame;

public class OptionDialog
extends TabDialog {
    private static final ApplicationLogger logger = new ApplicationLogger(OptionDialog.class);
    public static final String NAME_TAXONOMY_TREE = "Taxonomy Tree";
    public static final String NAME_PPM = "PPM";
    public static final String NAME_FUNC_COLOR = "Function Category Color";
    public static final String NAME_NEIGHBOR = "Neighboring Cluster";
    public static final String NAME_MA = "Multiple Alignment";
    public static final String NAME_TREE = "Tree";
    public static final String NAME_CALC = "Calculation";
    public static final String NAME_GENERAL = "General";
    public static final String NAME_PROJECT = "Project";
    private MediatorImpl mediator;

    public OptionDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.setShowDefaultButton(true);
        this.createComponents();
    }

    protected void addTabPanel() {
        this.tabbedPane.add(NAME_TAXONOMY_TREE, new TaxonomyTreeSettingPanel(this, this.mediator));
        this.tabbedPane.add(NAME_PPM, new PhylogeneticPatternOptionPanel(this, this.mediator));
        this.tabbedPane.add(NAME_NEIGHBOR, new NeighborOptionPanel(this, this.mediator));
        if (OptionTbl.getInstance().getOptionValues().isShowHiddenMenu()) {
            this.tabbedPane.add(NAME_MA, new MultipleAlignOptionPanel(this, this.mediator));
            this.tabbedPane.add(NAME_TREE, new TreeOptionPanel(this, this.mediator));
        }
        this.tabbedPane.add(NAME_PROJECT, new AuthOptionPanel(this));
        this.tabbedPane.add(NAME_GENERAL, new GeneralPanel(this, this.mediator));
    }

    protected boolean processApply() {
        try {
            OptionTbl.getInstance().writeOption();
        }
        catch (Exception exception) {
            String string = "Fail to save option.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
        return true;
    }
}

