/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorLegendPanel;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.StringTool;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PhylogeneticPatternOptionPanel
extends TabPanel {
    private MediatorImpl mediator;
    private JCheckBox geneCountColorCheckBox;
    private RestrictTextField geneCountColorTextField;
    private JCheckBox geneNameViewBox;
    private JCheckBox borderLineViewBox;
    private ColorLegendPanel cellColorLegendPanel;
    private ColorLegendPanel borderLineColorLegendPanel;
    private ColorLegendPanel ingroupColorLegendPanel;
    private ColorLegendPanel outgroupColorLegendPanel;
    private ColorLegendPanel outergroupColorLegendPanel;
    private ColorLegendPanel selectLine1ColorLegendPanel;
    private ColorLegendPanel selectLine2ColorLegendPanel;
    private ColorLegendPanel searchResultColorLegendPanel;
    private JCheckBox outgroupIngroupColorCheckBox;
    private ColorLegendPanel outgroupIngroupColorLegendPanel;

    PhylogeneticPatternOptionPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        this.geneCountColorCheckBox = new JCheckBox("Background color for cells containing inparalogs (>=");
        this.geneCountColorCheckBox.setSelected(optionTbl.getOptionValues().isGeneCountColorFlag());
        JLabel jLabel = new JLabel("gene)");
        this.geneCountColorTextField = new RestrictTextField();
        this.geneCountColorTextField.setColumns(4);
        this.geneCountColorTextField.setText(String.valueOf(optionTbl.getOptionValues().getGeneCountColorMinCount()));
        this.cellColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getGeneCountColor());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.geneCountColorCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.geneCountColorTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.cellColorLegendPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.geneNameViewBox = new JCheckBox("Display gene names or the number of genes:");
        this.geneNameViewBox.setSelected(optionTbl.getOptionValues().isGeneNameView());
        this.borderLineViewBox = new JCheckBox("Color for border lines:");
        this.borderLineViewBox.setSelected(optionTbl.getOptionValues().isBorderLineView());
        this.borderLineColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getBorderLineColorString());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.borderLineViewBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel2.add((Component)this.borderLineColorLegendPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        JLabel jLabel2 = new JLabel("Background color for ingroup cells:");
        this.ingroupColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getIngroupColorString());
        JLabel jLabel3 = new JLabel("Background color for outgroup cells:");
        this.outgroupColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getOutgroupColorString());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel3.add((Component)this.ingroupColorLegendPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel3.add((Component)jLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel3.add((Component)this.outgroupColorLegendPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        JLabel jLabel4 = new JLabel("Background color for outergroup cells:");
        this.outergroupColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getOutergroupColorString());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)jLabel4, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel4.add((Component)this.outergroupColorLegendPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.outgroupIngroupColorCheckBox = new JCheckBox("Background color for outgroup cells considered to be ingroup:");
        this.outgroupIngroupColorCheckBox.setSelected(optionTbl.getOptionValues().isOutgroupAsIngroupFlag());
        this.outgroupIngroupColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getOutgroupIngroupColorString());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.add((Component)this.outgroupIngroupColorCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel5.add((Component)this.outgroupIngroupColorLegendPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        JLabel jLabel5 = new JLabel("Background color for selected line cells(1):");
        this.selectLine1ColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getSelectLine1ColorString());
        JLabel jLabel6 = new JLabel("Background color for selected line cells(2):");
        this.selectLine2ColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getSelectLine2ColorString());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        jPanel6.add((Component)jLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel6.add((Component)this.selectLine1ColorLegendPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel6.add((Component)jLabel6, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel6.add((Component)this.selectLine2ColorLegendPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        JLabel jLabel7 = new JLabel("Background color for search result cells:");
        this.searchResultColorLegendPanel = new ColorLegendPanel(optionTbl.getOptionValues().getSearchResultColorString());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        jPanel7.add((Component)jLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel7.add((Component)this.searchResultColorLegendPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        int n = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 7, 3, 7), 0, 0));
        this.add((Component)this.geneNameViewBox, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 10, 3, 7), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 7, 3, 7), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 7, 3, 7), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 7, 3, 7), 0, 0));
        this.add((Component)jPanel5, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 7, 3, 7), 0, 0));
        this.add((Component)jPanel7, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 18, 0, new Insets(3, 7, 10, 7), 0, 0));
    }

    protected void changeDefault() {
        this.geneCountColorCheckBox.setSelected(false);
        this.geneCountColorTextField.setText(String.valueOf(2));
        this.cellColorLegendPanel.setColor("#ffa000");
        this.geneNameViewBox.setSelected(true);
        this.borderLineViewBox.setSelected(true);
        this.borderLineColorLegendPanel.setColor("#D3D3D3");
        this.ingroupColorLegendPanel.setColor("#008000");
        this.outgroupColorLegendPanel.setColor("#00FFFF");
        this.outergroupColorLegendPanel.setColor("#9999FF");
        this.outgroupIngroupColorCheckBox.setSelected(false);
        this.outgroupIngroupColorLegendPanel.setColor("#FF4500");
        this.selectLine1ColorLegendPanel.setColor("#800000");
        this.selectLine2ColorLegendPanel.setColor("#e06060");
        this.searchResultColorLegendPanel.setColor("#ff66ff");
    }

    public boolean check() {
        if (this.isGeneCountColor()) {
            String string = this.geneCountColorTextField.getText();
            if (StringTool.isNull(string)) {
                MessageManager.showErrorMessage((Component)this, "Input [Background color for cells containing inparalogs].");
                return false;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                MessageManager.showErrorMessage((Component)this, "Input [Background color for cells containing inparalogs].");
                return false;
            }
            if (n <= 1) {
                MessageManager.showErrorMessage((Component)this, "[Background color for cells containing inparalogs] is too small.");
                return false;
            }
        }
        return true;
    }

    protected void updateParameters() {
        boolean bl = false;
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        System.err.println("update!!");
        optionValues.setGeneCountColorFlag(this.isGeneCountColor());
        optionValues.setGeneCountColorMinCount(this.getGeneCountForGeneCountColor());
        optionValues.setGeneCountColor(this.getCellColor());
        optionValues.setGeneNameView(this.isGeneNameView());
        optionValues.setBorderLineView(this.isBorderLineView());
        optionValues.setBorderLineColorString(this.getBorderLineColor());
        optionValues.setIngroupColorString(this.getIngroupBackgroundColor());
        optionValues.setOutgroupColorString(this.getOutgroupBackgroundColor());
        optionValues.setOutergroupColorString(this.getOutergroupBackgroundColor());
        optionValues.setOutgroupAsIngroupFlag(this.isOutgroupAsIngroupBackgroundColor());
        optionValues.setOutgroupIngroupColorString(this.getOutgroupAsIngroupColor());
        optionValues.setSelectLine1ColorString(this.getSelectLine1());
        optionValues.setSelectLine2ColorString(this.getSelectLine2());
        optionValues.setSearchResultColorString(this.getSearchResult());
        this.mediator.updateColorTree();
        this.mediator.updateFromPPMSetting();
    }

    private boolean isGeneCountColor() {
        return this.geneCountColorCheckBox.isSelected();
    }

    private int getGeneCountForGeneCountColor() {
        return Integer.parseInt(this.geneCountColorTextField.getText());
    }

    private String getCellColor() {
        return ColorUtil.color2Str(this.cellColorLegendPanel.getBackground());
    }

    private boolean isGeneNameView() {
        return this.geneNameViewBox.isSelected();
    }

    private boolean isBorderLineView() {
        return this.borderLineViewBox.isSelected();
    }

    private String getBorderLineColor() {
        return ColorUtil.color2Str(this.borderLineColorLegendPanel.getBackground());
    }

    private String getIngroupBackgroundColor() {
        return ColorUtil.color2Str(this.ingroupColorLegendPanel.getBackground());
    }

    private String getOutgroupBackgroundColor() {
        return ColorUtil.color2Str(this.outgroupColorLegendPanel.getBackground());
    }

    private String getOutergroupBackgroundColor() {
        return ColorUtil.color2Str(this.outergroupColorLegendPanel.getBackground());
    }

    private boolean isOutgroupAsIngroupBackgroundColor() {
        return this.outgroupIngroupColorCheckBox.isSelected();
    }

    private String getOutgroupAsIngroupColor() {
        return ColorUtil.color2Str(this.outgroupIngroupColorLegendPanel.getBackground());
    }

    private String getSelectLine1() {
        return ColorUtil.color2Str(this.selectLine1ColorLegendPanel.getBackground());
    }

    private String getSelectLine2() {
        return ColorUtil.color2Str(this.selectLine2ColorLegendPanel.getBackground());
    }

    private String getSearchResult() {
        return ColorUtil.color2Str(this.searchResultColorLegendPanel.getBackground());
    }
}

