/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.option;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.multiplealign.ClustalWOption;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValidator;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.RestrictTextField;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class TreeOptionPanel
extends TabPanel
implements ActionListener {
    private static final int MARGIN_HORIZ_GUI = 15;
    private MediatorImpl mediator;
    private JComboBox kimuraComboBox;
    private JComboBox tossGapsComboBox;
    private JComboBox outputTreeComboBox;
    private JRadioButton bootstrapOnButton;
    private JRadioButton bootstrapOffButton;
    private RestrictTextField countTextField;
    private RestrictTextField seedTextField;

    TreeOptionPanel(Component component, MediatorImpl mediatorImpl) {
        super(component);
        this.mediator = mediatorImpl;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createLine1Panel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(15, 10, 5, 10), 0, 0));
        this.add((Component)this.createBootstrapPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.initValue();
    }

    private JPanel createLine1Panel() {
        JLabel jLabel = new JLabel("KIMURA");
        this.kimuraComboBox = new JComboBox<String>(ClustalWOption.ONOFF);
        JLabel jLabel2 = new JLabel("TOSSGAPS");
        this.tossGapsComboBox = new JComboBox<String>(ClustalWOption.ONOFF);
        JLabel jLabel3 = new JLabel("OUTPUTTREE");
        this.outputTreeComboBox = new JComboBox<String>(ClustalWOption.OUTPUTTREES);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)this.kimuraComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)this.tossGapsComboBox, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)this.outputTreeComboBox, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        return jPanel;
    }

    private JPanel createBootstrapPanel() {
        JLabel jLabel = new JLabel("BOOTSTRAP");
        this.bootstrapOnButton = new JRadioButton("ON");
        this.bootstrapOffButton = new JRadioButton("OFF");
        this.bootstrapOnButton.addActionListener(this);
        this.bootstrapOffButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bootstrapOnButton);
        buttonGroup.add(this.bootstrapOffButton);
        JLabel jLabel2 = new JLabel("COUNT");
        this.countTextField = new RestrictTextField(10);
        JLabel jLabel3 = new JLabel("SEED");
        this.seedTextField = new RestrictTextField(10);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)this.bootstrapOnButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)this.bootstrapOffButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)this.countTextField, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        jPanel.add((Component)this.seedTextField, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 15), 0, 0));
        return jPanel;
    }

    private void initValue() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        this.kimuraComboBox.setSelectedItem(optionValues.getClustalWOpt_KIMURA());
        this.tossGapsComboBox.setSelectedItem(optionValues.getClustalWOpt_TOSS());
        if (ClustalWOption.isOn(optionValues.getClustalWOpt_BS())) {
            this.bootstrapOnButton.setSelected(true);
        } else {
            this.bootstrapOffButton.setSelected(true);
        }
        this.countTextField.setText(String.valueOf(optionValues.getClustalWOpt_COUNT()));
        this.seedTextField.setText(String.valueOf(optionValues.getClustalWOpt_SEED()));
        this.setEnabledBootstrap();
    }

    private String getKimura() {
        return (String)this.kimuraComboBox.getSelectedItem();
    }

    private String getTossGaps() {
        return (String)this.tossGapsComboBox.getSelectedItem();
    }

    private String getOutputTree() {
        return (String)this.outputTreeComboBox.getSelectedItem();
    }

    private String getBootstrap() {
        return this.bootstrapOnButton.isSelected() ? "ON" : "OFF";
    }

    private int getCount() {
        return Integer.parseInt(this.countTextField.getText());
    }

    private int getSeed() {
        return Integer.parseInt(this.seedTextField.getText());
    }

    private void setEnabledBootstrap() {
        if (this.bootstrapOnButton.isSelected()) {
            this.countTextField.setEditable(true);
            this.seedTextField.setEditable(true);
        } else {
            this.countTextField.setEditable(false);
            this.seedTextField.setEditable(false);
        }
    }

    private boolean validateIntValue(JTextField jTextField, String string, int n, int n2) {
        return OptionValidator.validateIntValue(this, jTextField, string, n, n2);
    }

    protected void changeDefault() {
        this.kimuraComboBox.setSelectedItem("ON");
        this.tossGapsComboBox.setSelectedItem("ON");
        if (ClustalWOption.isOn("ON")) {
            this.bootstrapOnButton.setSelected(true);
        } else {
            this.bootstrapOffButton.setSelected(true);
        }
        this.countTextField.setText(String.valueOf(1000));
        this.seedTextField.setText(String.valueOf(111));
        this.setEnabledBootstrap();
    }

    public boolean check() {
        if (!this.validateIntValue(this.countTextField, "COUNT", 1, 10000)) {
            return false;
        }
        return this.validateIntValue(this.seedTextField, "SEED", 1, 1000);
    }

    protected void updateParameters() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        OptionValues optionValues = optionTbl.getOptionValues();
        optionValues.setClustalWOpt_KIMURA(this.getKimura());
        optionValues.setClustalWOpt_TOSS(this.getTossGaps());
        optionValues.setClustalWOpt_OTREE(this.getOutputTree());
        optionValues.setClustalWOpt_BS(this.getBootstrap());
        optionValues.setClustalWOpt_COUNT(this.getCount());
        optionValues.setClustalWOpt_SEED(this.getSeed());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bootstrapOnButton) {
            this.setEnabledBootstrap();
        } else if (actionEvent.getSource() == this.bootstrapOffButton) {
            this.setEnabledBootstrap();
        }
    }
}

