/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.data.TaxonomyTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismComparator;
import cgdp.recog.util.AbstractListSelectTableModel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CandidateOrganismTableModel
extends AbstractListSelectTableModel {
    private Map organismCodeIndexMap;

    public CandidateOrganismTableModel(List list) {
        super(list);
        TaxonomyTbl taxonomyTbl = new TaxonomyTbl();
        taxonomyTbl.read();
        this.organismCodeIndexMap = taxonomyTbl.getGenomeOrganismCodeIndexMap();
        Collections.sort(this.dataList, new OrganismComparator(this.organismCodeIndexMap));
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        Organism organism = (Organism)this.dataList.get(n);
        switch (n2) {
            case 0: {
                if (organism.isIngroup()) {
                    return "IN";
                }
                if (organism.isOutgroup()) {
                    return "OUT";
                }
                return "";
            }
            case 1: {
                return organism.getAbbrev() + " " + organism.getStrain();
            }
        }
        return "";
    }

    public int indexOf(Object object) {
        Organism organism;
        Organism organism2 = (Organism)object;
        int n = 0;
        Iterator iterator = this.dataList.iterator();
        while (iterator.hasNext() && !(organism = (Organism)iterator.next()).equalsOrganism(organism2)) {
            ++n;
        }
        return n;
    }

    protected void selectAfter() {
    }

    protected void removeAfter() {
        Collections.sort(this.dataList, new OrganismComparator(this.organismCodeIndexMap));
    }
}

