/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.AbstractMultiOrganism;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismCodeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MergeOrganism
extends AbstractMultiOrganism {
    public static final String DELIMTIER = "+";
    private String mergeOrganismName;

    protected MergeOrganism() {
        super(2);
    }

    public void setOrganismList(List list) {
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new OrganismCodeComparator());
        super.setOrganismList(list);
        this.setOrganismCode(this.createOrganismCode());
        this.mergeOrganismName = this.createDisplayOrganismName();
    }

    private String createOrganismCode() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.getOrganismCodeList()) {
            stringBuffer.append(string);
            if (n != this.getOrganismCount() - 1) {
                stringBuffer.append(DELIMTIER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String createDisplayOrganismName() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (Organism organism : this.getOrganismList()) {
            stringBuffer.append(organism.getDisplayOrganismName());
            if (n != this.getOrganismCount() - 1) {
                stringBuffer.append(DELIMTIER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getNameForTaxonomy() {
        return this.getDisplayOrganismName();
    }

    public String getDisplayOrganismName() {
        return this.mergeOrganismName;
    }

    public boolean containsParentOrganismCode(String string) {
        for (String string2 : this.getOrganismCodeList()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public List getSystemOrganismCodeList() {
        return this.getOrganismCodeList();
    }
}

