/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.DataManager;
import cgdp.recog.organism.MergeOrganism;
import cgdp.recog.organism.ModifiedOrganismManager;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismFactory;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;

public class OrganismMergeExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(OrganismMergeExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private Collection organismC;

    public OrganismMergeExecuter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, Collection collection) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.organismC = collection;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            MergeOrganism mergeOrganism = OrganismFactory.createMergeOrganism(this.organismC);
            this.clusterTbl.mergeOrganism(mergeOrganism);
            DataManager.createDomClustDataDir(this.clusterTbl.getClusterId());
            this.createChromosomeFile(mergeOrganism);
            this.createGeneFile(mergeOrganism);
            ApplicationPropertyFacade.saveProperty(this.clusterTbl.getClusterId(), ModifiedOrganismManager.getInstance());
        }
        catch (Exception exception) {
            String string = "Fail to split organism. " + OrganismUtil.getOrganismCodeList(this.organismC);
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private void createChromosomeFile(MergeOrganism mergeOrganism) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Organism organism : this.organismC) {
            String string = DataManager.getChromosomeFilePath(organism.getOrganismCode());
            int n2 = 1;
            if (n == 0) {
                n2 = 0;
            }
            String string2 = FileUtil.readFile(string, n2);
            string2 = string2.replaceAll("\t" + organism.getOrganismCode() + "\t", "\t" + mergeOrganism.getOrganismCode() + "\t");
            stringBuffer.append(string2);
            ++n;
        }
        FileUtil.outputFile(stringBuffer.toString(), DataManager.getDomClustChromosomeFilePath(this.clusterTbl.getClusterId(), mergeOrganism.getOrganismCode()));
    }

    private void createGeneFile(MergeOrganism mergeOrganism) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Organism organism : this.organismC) {
            String string = DataManager.getGeneFilePath(organism.getOrganismCode());
            int n2 = 1;
            if (n == 0) {
                n2 = 0;
            }
            String string2 = FileUtil.readFile(string, n2);
            string2 = string2.replaceAll("\t" + organism.getOrganismCode() + "\t", "\t" + mergeOrganism.getOrganismCode() + "\t");
            stringBuffer.append(string2);
            ++n;
        }
        FileUtil.outputFile(stringBuffer.toString(), DataManager.getDomClustGeneFilePath(this.clusterTbl.getClusterId(), mergeOrganism.getOrganismCode()));
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        this.mediator.resetMainWindowNotClearView();
        this.mediator.updateTaxonomyTree();
        this.mediator.updateOrganismColumnTree();
        this.mediator.updatePatternTree();
        this.mediator.updateOrganismSetTree();
    }
}

