/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.organism;

import cgdp.recog.organism.OrganismSet;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.util.List;

public class OrganismSetExporter
extends FileExporter {
    private static final String TITLE_ORGANISM_SET = "OrganismSet";
    private static final String PREFIX_NAME = "#NAME";
    private static final String DELIMITER_PARAM = "\t";
    private static final String DELIMITER_SP = ",";
    private static final String DELIMITER_ORGANISM = "//";
    private String filepath;
    private List organismSetList;

    public OrganismSetExporter(List list, String string) {
        this.filepath = string;
        this.organismSetList = list;
    }

    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (OrganismSet organismSet : this.organismSetList) {
            stringBuffer.append(TITLE_ORGANISM_SET);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(OrganismSetExporter.createParameterString(PREFIX_NAME, organismSet.getName()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(this.getOrganismString(organismSet));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(DELIMITER_ORGANISM);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String createParameterString(String string, String string2) {
        return string + DELIMITER_PARAM + string2;
    }

    private String getOrganismString(OrganismSet organismSet) {
        return StringTool.conbineStrList(organismSet.getOrganismCodeList(), DELIMITER_SP);
    }

    protected String getFilepath() {
        return this.filepath;
    }
}

