/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.patch;

import cgdp.recog.bean.Const;
import cgdp.recog.patch.AbstractPatch;
import cgdp.recog.patch.CellInfoModPatch;
import cgdp.recog.patch.ClusterInfoConfModPatch;
import cgdp.recog.patch.ClusterInfoConfModPatch2;
import cgdp.recog.patch.GeneInfoConfModPatch;
import cgdp.recog.patch.GeneUrlFilePatch;
import cgdp.recog.patch.Patch;
import cgdp.recog.patch.PatchComparator;
import cgdp.recog.patch.PatchHistoryExporter;
import cgdp.recog.patch.ProjectConfModPatch;
import cgdp.recog.patch.PropertyConfUpdatePatch;
import cgdp.recog.patch.SetConditionGroupFilePatch;
import cgdp.recog.patch.SetConfAddIDPatch;
import cgdp.recog.patch.UserGeneInfoAddConfPatch;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileImporter;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PatchExecuter {
    private static final ApplicationLogger logger = new ApplicationLogger(PatchExecuter.class);
    private static final String PATCH_INFO_PATH = Const.USER_PATCH_INFO_PATH;

    private PatchExecuter() {
    }

    public static void executePatch() {
        String string = PatchExecuter.getPatchHistory();
        List list = PatchExecuter.getPatchList();
        boolean bl = false;
        Date date = null;
        for (Patch patch : list) {
            if (!patch.isExecutable(string)) continue;
            patch.execute();
            bl = true;
            if (date == null) {
                date = patch.getPatchReleaseDate();
                continue;
            }
            if (date.compareTo(patch.getPatchReleaseDate()) != -1) continue;
            date = patch.getPatchReleaseDate();
        }
        if (bl) {
            PatchExecuter.savePatchHistory(date);
        }
    }

    private static String getPatchHistory() {
        try {
            PatchHistoryImporter patchHistoryImporter = new PatchHistoryImporter();
            patchHistoryImporter.execute();
            return patchHistoryImporter.getPatchHistory();
        }
        catch (Exception exception) {
            logger.warn("Fail to get patch history.", exception);
            return "2000/4/1";
        }
    }

    public static void savePatchHistory(Date date) {
        try {
            String string = AbstractPatch.DATE_FORMAT.format(date);
            PatchHistoryExporter patchHistoryExporter = new PatchHistoryExporter(string);
            patchHistoryExporter.execute();
        }
        catch (Exception exception) {
            logger.warn("Fail to save patch history.", exception);
        }
    }

    private static List getPatchList() {
        ArrayList<AbstractPatch> arrayList = new ArrayList<AbstractPatch>();
        arrayList.add(new GeneUrlFilePatch());
        arrayList.add(new SetConfAddIDPatch());
        arrayList.add(new UserGeneInfoAddConfPatch());
        arrayList.add(new ClusterInfoConfModPatch());
        arrayList.add(new CellInfoModPatch());
        arrayList.add(new PropertyConfUpdatePatch());
        arrayList.add(new ClusterInfoConfModPatch2());
        arrayList.add(new GeneInfoConfModPatch());
        arrayList.add(new ProjectConfModPatch());
        arrayList.add(new SetConditionGroupFilePatch());
        Collections.sort(arrayList, new PatchComparator());
        return arrayList;
    }

    private static class PatchHistoryImporter
    extends FileImporter {
        private String patchHistory;

        PatchHistoryImporter() {
            this.setExistHeader(false);
        }

        protected String getFilepath() {
            return PATCH_INFO_PATH;
        }

        protected void parseDataLine(int n, String string) {
            this.patchHistory = string;
        }

        protected void parseHeaderLine(String string) {
        }

        public String getPatchHistory() {
            return this.patchHistory;
        }
    }
}

