/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.process;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.process.SingleTaskManager;
import cgdp.recog.util.ApplicationLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends JDialog
implements ActionListener,
Runnable,
ProgressImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(ProgressDialog.class);
    private MediatorImpl mediator;
    private int totalProgress;
    private String[] statusMessages;
    private boolean cancelProcess;
    private boolean backgroundProcess = true;
    private ProcessImpl processImpl;
    private JLabel[] statusMessageLabels;
    private JProgressBar progressBar;
    private JButton backgroundButton;
    private JButton cancelButton;
    private boolean cancel = false;
    private int progress;
    private int m_no = 0;
    private Process process;

    public static ProgressDialog executeProgress(Component component, MediatorImpl mediatorImpl, int n, String string, boolean bl, ProcessImpl processImpl) {
        if (component instanceof Frame) {
            return new ProgressDialog((Frame)component, mediatorImpl, n, string, bl, processImpl);
        }
        if (component instanceof Dialog) {
            return new ProgressDialog((Dialog)component, mediatorImpl, n, string, bl, processImpl);
        }
        return null;
    }

    public static ProgressDialog executeProgress(Component component, MediatorImpl mediatorImpl, int n, String[] stringArray, boolean bl, ProcessImpl processImpl) {
        if (component instanceof Frame) {
            return new ProgressDialog((Frame)component, mediatorImpl, n, stringArray, bl, processImpl);
        }
        if (component instanceof Dialog) {
            return new ProgressDialog((Dialog)component, mediatorImpl, n, stringArray, bl, processImpl);
        }
        return null;
    }

    public ProgressDialog(Frame frame, MediatorImpl mediatorImpl, int n, String string, boolean bl, ProcessImpl processImpl) {
        super(frame, true);
        String[] stringArray = new String[]{string};
        this.init(frame, mediatorImpl, n, stringArray, bl, false, processImpl);
    }

    public ProgressDialog(Dialog dialog, MediatorImpl mediatorImpl, int n, String string, boolean bl, ProcessImpl processImpl) {
        super(dialog, true);
        String[] stringArray = new String[]{string};
        this.init(dialog, mediatorImpl, n, stringArray, bl, false, processImpl);
    }

    public ProgressDialog(Frame frame, MediatorImpl mediatorImpl, int n, String[] stringArray, boolean bl, ProcessImpl processImpl) {
        super(frame, true);
        this.init(frame, mediatorImpl, n, stringArray, bl, false, processImpl);
    }

    public ProgressDialog(Dialog dialog, MediatorImpl mediatorImpl, int n, String[] stringArray, boolean bl, ProcessImpl processImpl) {
        super(dialog, true);
        this.init(dialog, mediatorImpl, n, stringArray, bl, false, processImpl);
    }

    public ProgressDialog(Frame frame, MediatorImpl mediatorImpl, int n, String[] stringArray, boolean bl, boolean bl2, ProcessImpl processImpl) {
        super(frame, true);
        this.init(frame, mediatorImpl, n, stringArray, bl, bl2, processImpl);
    }

    private void init(Component component, MediatorImpl mediatorImpl, int n, String[] stringArray, boolean bl, boolean bl2, ProcessImpl processImpl) {
        this.mediator = mediatorImpl;
        this.totalProgress = n;
        this.statusMessages = stringArray;
        this.cancelProcess = bl;
        this.backgroundProcess = bl2;
        this.processImpl = processImpl;
        this.clear();
        this.setTitle("Wait");
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        if (this.cancelProcess) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ProgressDialog.this.cancelProgress();
                }
            });
        }
        this.createComponent();
        this.pack();
        this.setLocationRelativeTo(component);
        if (this.backgroundProcess) {
            SingleTaskManager singleTaskManager = SingleTaskManager.getInstance();
            singleTaskManager.execute(this);
            this.setVisible(true);
        } else {
            Thread thread = new Thread(this);
            thread.setPriority(1);
            thread.start();
            this.setVisible(true);
        }
    }

    private void clear() {
        this.statusMessageLabels = new JLabel[this.statusMessages.length];
        this.cancel = false;
        this.progress = 0;
        this.m_no = 0;
        this.process = null;
    }

    private void createComponent() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.statusMessages.length; ++n2) {
            this.statusMessageLabels[n2] = new JLabel(this.statusMessages[n2]);
        }
        if (this.statusMessages.length > 1) {
            this.statusMessageLabels[0].setForeground(Color.red);
            for (n2 = 1; n2 < this.statusMessageLabels.length; ++n2) {
                this.statusMessageLabels[n2].setEnabled(false);
            }
        }
        this.progressBar = new JProgressBar(0, this.totalProgress);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("0%");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setVisible(this.cancelProcess);
        this.backgroundButton = new JButton("Run in background");
        this.backgroundButton.addActionListener(this);
        this.backgroundButton.setVisible(this.backgroundProcess);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.backgroundButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        for (n = 0; n < this.statusMessages.length; ++n) {
            this.getContentPane().add((Component)this.statusMessageLabels[n], new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        n = this.statusMessages.length;
        this.getContentPane().add((Component)this.progressBar, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, n + 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void cancelProgress() {
        this.cancel = true;
        this.cancelButton.setEnabled(false);
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.setVisible(false);
    }

    private void backgroundProcess() {
        this.setVisible(false);
        this.mediator.showBackgroundProgressBar(true);
    }

    public void setTotal(int n) {
        this.totalProgress = n;
        this.progressBar.setMaximum(this.totalProgress);
    }

    public void setCount(int n) {
        this.progress = n;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void nextProc() {
        this.progress = 0;
        this.statusMessageLabels[this.m_no].setEnabled(false);
        logger.info("Status: " + this.statusMessageLabels[this.m_no].getText() + " " + this.statusMessageLabels.length);
        if (this.m_no <= this.statusMessageLabels.length) {
            ++this.m_no;
        }
        this.statusMessageLabels[this.m_no].setEnabled(true);
        this.statusMessageLabels[this.m_no].setForeground(Color.red);
    }

    public void setEnabledBackgroundButton(boolean bl) {
        this.backgroundButton.setEnabled(bl);
    }

    public void setEnabledCancelButton(boolean bl) {
        this.cancelButton.setEnabled(bl);
    }

    public void run() {
        try {
            do {
                Thread.sleep(200L);
            } while (!this.isVisible());
        }
        catch (Exception exception) {
            logger.warn("Fail to show progress dialog.", exception);
        }
        this.processImpl.execute(this);
        this.dispose();
        if (!this.isCanceled()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressDialog.this.processImpl.done();
                }
            });
        }
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    public void increment() {
        if (this.totalProgress > 0) {
            int n = (int)((double)(++this.progress) / (double)this.totalProgress * 100.0);
            this.progressBar.setValue(this.progress);
            this.progressBar.setString(String.valueOf(n + "%"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.cancelProgress();
        } else if (actionEvent.getSource() == this.backgroundButton) {
            this.backgroundProcess();
        }
    }
}

