/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.process;

import cgdp.recog.process.ProgressDialog;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;

public class SingleTaskManager {
    private static final SingleTaskManager SINGLETASKMANAGER = new SingleTaskManager();
    private Executor executer = Executors.newSingleThreadExecutor(new MinTreadFactory());
    private ReentrantLock lock = new ReentrantLock();
    private ProgressDialog progressDialog;

    public static SingleTaskManager getInstance() {
        return SINGLETASKMANAGER;
    }

    public boolean execute(ProgressDialog progressDialog) {
        if (this.lock.isLocked()) {
            return false;
        }
        LockTask lockTask = new LockTask(progressDialog);
        this.executer.execute(lockTask);
        this.progressDialog = progressDialog;
        return true;
    }

    public boolean isExecuteTask() {
        return this.lock.isLocked();
    }

    public ProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    private class MinTreadFactory
    implements ThreadFactory {
        private MinTreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            return thread;
        }
    }

    private class LockTask
    implements Runnable {
        private Runnable task;

        public LockTask(Runnable runnable) {
            this.task = runnable;
        }

        public void run() {
            SingleTaskManager.this.lock.lock();
            try {
                this.task.run();
            }
            finally {
                SingleTaskManager.this.progressDialog = null;
                SingleTaskManager.this.lock.unlock();
            }
        }
    }
}

