/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.project;

import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AnalysisUploadDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Save domclust results on server";
    private FocusTextField nameTextField;
    private JTextArea descriptionArea;
    private JCheckBox overwriteCheckBox;
    private JCheckBox viewParameterCheckBox;

    private AnalysisUploadDialog(Frame frame, boolean bl) {
        super(frame);
        this.createComponents(bl);
    }

    private AnalysisUploadDialog(Dialog dialog, boolean bl) {
        super(dialog);
        this.createComponents(bl);
    }

    public static AnalysisUploadDialog createInstance(Component component, boolean bl) {
        AnalysisUploadDialog analysisUploadDialog = null;
        if (component instanceof Dialog) {
            analysisUploadDialog = new AnalysisUploadDialog((Dialog)component, bl);
        } else if (component instanceof Frame) {
            analysisUploadDialog = new AnalysisUploadDialog((Frame)component, bl);
        }
        return analysisUploadDialog;
    }

    private void createComponents(boolean bl) {
        this.setTitle(TITLE);
        this.setModal(true);
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JLabel jLabel2 = new JLabel("Description");
        this.descriptionArea = new JTextArea(4, 40);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionArea, 20, 31);
        this.overwriteCheckBox = new JCheckBox("Overwrite");
        this.viewParameterCheckBox = new JCheckBox("Save view parameters");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 5), 0, 0));
        this.getContentPane().add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 10, 15), 0, 0));
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 5, 5), 0, 0));
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 15, 10, 15), 0, 0));
        if (bl) {
            this.getContentPane().add((Component)this.viewParameterCheckBox, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 15, 10, 15), 0, 0));
        }
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateValue(String string, String string2, String string3) {
        this.nameTextField.setText(string);
        this.descriptionArea.setText(string2);
        this.setTitle(string3);
    }

    public String getAnalysisName() {
        return this.nameTextField.getText();
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    public boolean isOverwrite() {
        return this.overwriteCheckBox.isSelected();
    }

    public boolean isViewParameters() {
        return this.viewParameterCheckBox.isSelected();
    }

    protected boolean check() {
        if (StringTool.isNull(this.getName())) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        return true;
    }

    protected boolean apply() {
        return true;
    }
}

