/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.propvect;

import cgdp.recog.hcluster.HClustException;
import cgdp.recog.propvect.CalcCorrelation;
import cgdp.recog.propvect.CalcDistance;
import cgdp.recog.propvect.CalcDistanceNumVect;
import cgdp.recog.propvect.CalcEuclidDistance;
import cgdp.recog.propvect.CompressedPropVectArray;
import cgdp.recog.propvect.NumVect;
import cgdp.recog.propvect.PropVect;
import cgdp.recog.propvect.PropVectArray;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class NumVectArray
extends PropVectArray {
    public static final int CORR = 0;
    public static final int CORR_ABS = 1;
    public static final int DIST = 2;
    public static final int INFO = 3;
    public static final int PROB = 4;
    public static final int E_DIST = 5;

    public NumVectArray() {
        this.vectSet = new ArrayList();
    }

    public NumVectArray(int n) {
        this();
        this.colnum = n;
    }

    PropVect createNewElement(String string) {
        return new NumVect(this.colnum, string);
    }

    public void add(NumVect numVect) {
        this.vectSet.add(numVect);
    }

    CalcDistance createCalcDistance(int n, double d) {
        CalcDistanceNumVect calcDistanceNumVect;
        switch (n) {
            default: {
                calcDistanceNumVect = new CalcCorrelation(false);
                break;
            }
            case 1: {
                calcDistanceNumVect = new CalcCorrelation(true);
                break;
            }
            case 5: {
                calcDistanceNumVect = new CalcEuclidDistance();
            }
        }
        return calcDistanceNumVect;
    }

    CalcDistance createCalcProbability(double d) {
        return null;
    }

    void printComparison(int n, int n2, double d) {
        this.printComparison((NumVect)this.vectSet.get(n), (NumVect)this.vectSet.get(n2), d);
    }

    void printComparison(NumVect numVect, NumVect numVect2, double d) {
        DecimalFormat decimalFormat = new DecimalFormat("####0.########");
        System.out.println(numVect.getName() + " " + numVect2.getName() + " " + decimalFormat.format(d));
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        int n = 0;
        double d = 2.0;
        double d2 = 2.0;
        if (stringArray.length >= 2) {
            n = Integer.valueOf(stringArray[1]);
        }
        if (stringArray.length >= 3) {
            d = Double.valueOf(stringArray[2]);
        }
        if (stringArray.length >= 4) {
            d2 = Double.valueOf(stringArray[3]);
        }
        NumVectArray numVectArray = new NumVectArray();
        try {
            numVectArray.readFromFile(string);
            if (numVectArray == null) {
                System.err.println("Can't read file: " + string);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("Can't open file: " + string);
            System.exit(1);
        }
        CompressedPropVectArray compressedPropVectArray = numVectArray.doCompress();
        try {
            compressedPropVectArray.compareAll(n, d, d2, null, true);
        }
        catch (HClustException hClustException) {
            System.err.println("Can't compareAll: " + string);
            System.exit(1);
        }
    }
}

