/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.dgGraphics;
import cgdp.recog.ptree.bean.interfaces.ShapeImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class BaseShape
implements ShapeImpl,
Cloneable,
Serializable {
    protected static int stLastID = 0;
    protected transient Graphics m_g;
    protected transient dgGraphics m_dg;
    protected transient Rectangle m_oldRect;
    protected transient boolean m_isSelected;
    protected transient boolean m_isVisible;
    protected Rectangle m_rect;
    protected transient int m_id;
    protected transient boolean m_isLocked;
    protected transient Color m_color;
    protected transient boolean m_isMagnify;
    protected transient double m_magX;
    protected transient double m_magY;

    public BaseShape() {
        this.init(new Rectangle());
    }

    public BaseShape(Rectangle rectangle) {
        this.init(new Rectangle(rectangle));
    }

    public BaseShape(int n, int n2, int n3, int n4) {
        this.init(new Rectangle(n, n2, n3, n4));
    }

    protected void init(Rectangle rectangle) {
        this.m_id = ++stLastID;
        this.m_isLocked = false;
        this.m_rect = rectangle;
        this.m_isVisible = true;
        this.m_color = Color.black;
        this.m_oldRect = this.getBounds();
        this.m_isMagnify = false;
        this.m_magX = 1.0;
        this.m_magY = 1.0;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public boolean isVisible() {
        return this.m_isVisible;
    }

    public void setVisible(boolean bl) {
        this.m_isVisible = bl;
    }

    public boolean isSelected() {
        return this.m_isSelected;
    }

    public void setSelected(boolean bl) {
        if (this.m_isSelected != bl) {
            this.m_isSelected = bl;
        }
    }

    public void setGraphics(dgGraphics dgGraphics2) {
        this.m_dg = dgGraphics2;
        this.m_dg.setGraphics(this.m_g);
    }

    public void setGraphics(Graphics graphics, dgGraphics dgGraphics2) {
        this.m_g = graphics;
        this.m_dg = dgGraphics2;
        this.m_dg.setGraphics(this.m_g);
    }

    public void setID(int n) {
        this.m_id = n;
    }

    public void setBound(Rectangle rectangle) {
        this.m_rect = rectangle;
    }

    public void setGraphics(Graphics graphics) {
        this.m_g = graphics;
        if (this.m_dg == null) {
            this.m_dg = new dgGraphics(this.m_g);
        } else {
            this.m_dg.setGraphics(this.m_g);
        }
    }

    public void draw() {
        if (this.m_isVisible) {
            this.setPen();
            if (this.m_color == null) {
                this.drawOutline();
            } else {
                this.drawShape();
            }
            this.unsetPen();
        }
    }

    public void drawShape() {
        this.m_g.fillRect(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
    }

    private void unsetPen() {
        this.m_g.setColor(Color.black);
    }

    public void drawOutline() {
        this.m_g.drawRect(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
    }

    public void setPen() {
        if (this.m_color != null) {
            this.m_g.setColor(this.m_color);
        }
    }

    public void highlight(int n, int n2) {
        if (n != n2 && 0 < n2 && this.m_isSelected) {
            this.drawOutline();
        }
    }

    protected void highlightOnOff(Rectangle rectangle, boolean bl, boolean bl2) {
        this.m_g.setXORMode(Color.white);
        this.m_g.fillRect(rectangle.x + this.m_dg.offsetX(), rectangle.y + this.m_dg.offsetY(), rectangle.width, rectangle.height);
        this.m_g.setPaintMode();
    }

    public void setMagnify(boolean bl, double d, double d2) {
        this.m_isMagnify = false;
        this.m_magX = d;
        this.m_magY = d2;
        if (this.m_dg != null) {
            this.m_dg.setMagnified(bl, d, d2);
        }
    }

    public int ID() {
        return this.m_id;
    }

    public int getX() {
        return this.m_rect.x;
    }

    public int getY() {
        return this.m_rect.y;
    }

    public boolean contains(int n, int n2) {
        return this.m_rect.contains(n, n2);
    }

    public void move(int n, int n2) {
        this.setBounds(n, n2, this.m_rect.width, this.m_rect.height);
    }

    public void grow(int n, int n2) {
        this.setBounds(this.m_rect.x - n, this.m_rect.y - n2, this.m_rect.width + 2 * n, this.m_rect.height + 2 * n2);
    }

    public void translate(int n, int n2) {
        this.setBounds(this.m_rect.x + n, this.m_rect.y + n2, this.m_rect.width, this.m_rect.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_oldRect = this.getBounds();
        this.m_rect.setBounds(n, n2, n3, n4);
        this.updateBounds();
    }

    public void updateBounds() {
        if (this.m_dg != null) {
            this.m_dg.setBounds(this.m_rect);
        }
    }

    public boolean isLocked() {
        return this.m_isLocked;
    }

    public void setLocked(boolean bl) {
        this.m_isLocked = bl;
    }

    public Object clone() {
        try {
            BaseShape baseShape = (BaseShape)super.clone();
            Rectangle rectangle = this.getBounds();
            baseShape.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            baseShape.setID(++stLastID);
            return baseShape;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean contains(double d, double d2) {
        return this.m_rect.contains(d, d2);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.m_rect.contains(d, d2, d3, d4);
    }

    public boolean contains(Point2D point2D) {
        return this.contains((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.m_rect.contains(rectangle2D);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.m_rect);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.m_rect);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return null;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return null;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.m_rect.intersects(d, d2, d3, d4);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.m_rect.intersects(rectangle2D);
    }

    public String toString() {
        String string = this.getClass().getName() + "[rect=" + this.m_rect.toString() + ",isLocked=" + this.m_isLocked + ",color=";
        string = string + (this.m_color == null ? "null" : this.m_color.toString());
        string = string + "]";
        return string;
    }
}

