/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.bean;

import cgdp.recog.ptree.bean.BaseShape;
import cgdp.recog.ptree.bean.CalcTree;
import cgdp.recog.ptree.bean.NodeStyle;
import cgdp.recog.ptree.bean.Plotter;
import cgdp.recog.ptree.bean.TextStyle;
import cgdp.recog.ptree.bean.Tree;
import cgdp.recog.ptree.bean.data.DPoint;
import cgdp.recog.ptree.bean.dgGraphics;
import cgdp.recog.ptree.bean.interfaces.NodeStyleImpl;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class ScaleShape
extends BaseShape
implements NodeStyleImpl {
    protected Tree m_tree;
    protected Component m_comp;
    protected CalcTree m_calc;
    protected TextStyle m_ncStyle;
    protected Vector m_textStyles;
    protected Plotter m_plotter;
    protected int m_cWide;
    protected int m_cHigh;
    protected int m_cDescent;
    protected int m_halfLbWidth;
    protected int m_shapeHeight;
    protected boolean m_isNeedToLocate;
    protected boolean m_isUseLengths;
    protected boolean m_isVertical;
    protected String m_label;
    protected NodeStyle m_ndStyle;
    protected Point m_pstart;
    protected Point m_pend;
    protected DPoint m_dstart;
    protected DPoint m_dend;

    public ScaleShape(Component component, Tree tree, CalcTree calcTree) {
        super(component.getBounds());
        this.m_comp = component;
        this.m_calc = calcTree;
        this.m_tree = tree;
        this.init();
    }

    protected void init() {
        this.m_g = this.m_comp.getGraphics();
        this.m_dg = new dgGraphics(this.m_g);
        this.m_plotter = new Plotter(this.m_g, this.m_dg);
        this.m_ncStyle = new TextStyle();
        this.m_textStyles = this.m_tree.getTextStyles();
        this.m_label = new String("0.0");
        this.m_ndStyle = new NodeStyle();
        this.m_ndStyle.setDoOutline(true);
        this.m_ndStyle.setHidden(!this.m_tree.isUseLengths());
        this.m_pstart = new Point(0, 0);
        this.m_pend = new Point(0, 0);
        this.m_dstart = new DPoint();
        this.m_dend = new DPoint();
        this.m_isNeedToLocate = true;
        this.setShapeRect();
    }

    public void setTextStyle(TextStyle textStyle) {
        this.m_ncStyle = textStyle;
    }

    public void setNodeStyle(NodeStyle nodeStyle) {
        this.m_ndStyle = nodeStyle;
    }

    public void setStartP(Point point) {
        this.m_pstart = point;
    }

    public void setEndP(Point point) {
        this.m_pend = point;
    }

    public void setStartDP(DPoint dPoint) {
        this.m_dstart = dPoint;
    }

    public void setEndDP(DPoint dPoint) {
        this.m_dend = dPoint;
    }

    public Object clone() {
        ScaleShape scaleShape = (ScaleShape)super.clone();
        scaleShape.setTextStyle((TextStyle)this.m_ncStyle.clone());
        scaleShape.setNodeStyle(new NodeStyle(this.m_ndStyle));
        scaleShape.setStartP(new Point(this.m_pstart.x, this.m_pstart.y));
        scaleShape.setEndP(new Point(this.m_pend.x, this.m_pend.y));
        scaleShape.setStartDP(new DPoint(this.m_dstart));
        scaleShape.setEndDP(new DPoint(this.m_dend));
        return scaleShape;
    }

    protected void getTextSize() {
        if (this.m_g != null) {
            FontMetrics fontMetrics = this.m_g.getFontMetrics();
            this.m_cWide = fontMetrics.charWidth('G');
            this.m_cHigh = fontMetrics.getAscent();
            this.m_cDescent = fontMetrics.getDescent();
            this.m_halfLbWidth = fontMetrics.stringWidth(this.m_label) / 2;
            this.m_shapeHeight = fontMetrics.getHeight() + 5;
        } else {
            Font font = this.m_comp.getFont();
            if (font == null && font == null) {
                font = new Font("Dialog", 0, 10);
            }
            BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            LineMetrics lineMetrics = font.getLineMetrics("G", fontRenderContext);
            this.m_cHigh = (int)lineMetrics.getAscent();
            this.m_cDescent = (int)lineMetrics.getDescent();
            this.m_shapeHeight = (int)lineMetrics.getHeight() + 5;
            this.m_cWide = 16;
            this.m_halfLbWidth = this.m_cWide * this.m_label.length() / 2;
        }
    }

    public void recalcTree() {
        if (this.m_isUseLengths != this.m_tree.isUseLengths()) {
            this.m_ndStyle.setHidden(!this.m_tree.isUseLengths());
        }
        this.setShapeRect();
    }

    public void rescaleTree() {
        if (this.m_isUseLengths != this.m_tree.isUseLengths()) {
            this.m_ndStyle.setHidden(!this.m_tree.isUseLengths());
        }
        this.setShapeRect();
    }

    public final NodeStyle getNodeStyle() {
        return this.m_ndStyle;
    }

    protected void plot(boolean bl, DPoint dPoint, Point point) {
        Point point2 = this.m_dg.map2port(dPoint.x, dPoint.y);
        if (bl) {
            this.m_dg.lineto(point2);
        } else {
            this.m_dg.moveto(point2);
        }
        this.m_dg.getPen(point);
    }

    public void drawShape() {
        if (!this.m_ndStyle.isHidden()) {
            if (this.m_isNeedToLocate) {
                this.relocate();
            }
            this.m_g.setFont(this.m_ncStyle.getFont());
            this.getTextSize();
            if (!this.m_color.equals(this.m_ncStyle.getColor())) {
                this.m_g.setColor(this.m_ncStyle.getColor());
            }
            this.plot(false, this.m_dstart, this.m_pstart);
            this.plot(true, this.m_dend, this.m_pend);
            if (this.m_ndStyle.isDoOutline()) {
                this.m_dg.moveto(this.m_pstart);
                if (this.m_isVertical) {
                    this.m_dg.line(0, 5);
                } else {
                    this.m_dg.line(5, 0);
                }
                this.m_dg.moveto(this.m_pend);
                if (this.m_isVertical) {
                    this.m_dg.line(0, 5);
                } else {
                    this.m_dg.line(5, 0);
                }
                if (this.m_ndStyle.isDoBox()) {
                    this.drawOutline();
                }
                if (!this.m_ndStyle.isNoLabel()) {
                    this.m_dg.moveto((this.m_pstart.x + this.m_pend.x) / 2, (this.m_pstart.y + this.m_pend.y) / 2);
                    if (this.m_isVertical) {
                        this.m_dg.move(this.m_cWide, this.m_cHigh);
                    } else {
                        this.m_dg.move(-this.m_halfLbWidth, this.m_cHigh);
                    }
                    this.m_dg.drawString(this.m_label);
                }
            }
            if (!this.m_color.equals(this.m_ncStyle.getColor())) {
                this.m_g.setColor(this.m_color);
            }
        }
    }

    private void relocate() {
        int n;
        int n2;
        Rectangle rectangle = this.m_tree.getBounds();
        if (this.m_isVertical) {
            n2 = 40;
            n = 40;
        } else {
            n2 = 10;
            n = 40;
        }
        this.move(n2, n);
        this.m_isNeedToLocate = false;
    }

    protected void setShapeRect() {
        this.getTextSize();
        this.m_isVertical = this.m_tree.isVertical();
        this.m_isUseLengths = this.m_tree.isUseLengths();
        double d = this.m_tree.getTmax().x - this.m_tree.getTmin().x;
        double d2 = this.m_tree.getTmax().y - this.m_tree.getTmin().y;
        double d3 = this.m_calc.scalebar();
        this.m_label = Double.toString(d3);
        if (this.m_isVertical) {
            this.m_dstart = new DPoint(this.m_tree.getTmin().x, this.m_tree.getTmin().y);
            this.m_dend = new DPoint(this.m_dstart);
            this.m_dend.y += d2 * d3;
        } else {
            this.m_dstart = new DPoint(this.m_tree.getTmin().x, this.m_tree.getTmin().y);
            this.m_dend = new DPoint(this.m_dstart);
            this.m_dend.x += d * d3;
        }
        this.m_dg.setGrXmin(this.m_dstart.x);
        this.m_dg.setGrYmax(this.m_dend.y);
        this.m_dg.setDrawScale(this.m_tree.getScale());
        d = this.m_dend.x - this.m_dstart.x;
        d2 = this.m_dend.y - this.m_dstart.y;
        DPoint dPoint = this.m_dg.getDrawScale();
        int n = (int)Math.max((long)(this.m_halfLbWidth * 2), Math.round(d * dPoint.x));
        int n2 = (int)Math.max((long)this.m_shapeHeight, Math.round(d2 * dPoint.y));
        if (this.m_isVertical) {
            n += this.m_cWide * 2;
            n2 += this.m_cHigh;
        } else {
            n += this.m_cWide;
        }
        this.setBounds(this.m_rect.x, this.m_rect.y, n, n2);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.m_tree.toString() + "]";
    }
}

