/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.ptree.startup;

import cgdp.recog.ptree.bean.PtreeMainWindow;
import cgdp.recog.ptree.bean.interfaces.RecogQueryImpl;
import cgdp.recog.ptree.startup.TimerListener;
import java.io.File;
import javax.swing.Timer;

public class Test
implements RecogQueryImpl {
    public static final String[] SpeciesColors = new String[]{"#ff0000", "#ff99cc", "#ff9900", "#a0a000", "#99cc00", "#008000", "#33cccc", "#0000ff", "#800080", "#993300"};
    String m_dndFile;
    String m_inGroupColor;
    String m_outGroupColor;
    boolean m_isReverse;
    Timer m_timer;

    public Test(String string) {
        this.m_dndFile = string;
        this.m_inGroupColor = "#ff0000";
        this.m_outGroupColor = "#0000ff";
        this.m_isReverse = false;
        this.m_timer = null;
    }

    public void setReverse(boolean bl) {
        this.m_isReverse = bl;
    }

    public boolean isReverse() {
        return this.m_isReverse;
    }

    public String getInGroupColor() {
        return this.m_inGroupColor;
    }

    public String getOutGroupColor() {
        return this.m_outGroupColor;
    }

    public boolean isInGroup(String string) {
        int n = this.speciesToNumber(string);
        if (0 < n) {
            n %= 2;
        }
        boolean bl = n == 0;
        System.out.println("spid=" + string);
        System.out.println("isInGroup=" + bl);
        System.out.println("isReverse=" + this.m_isReverse);
        if (this.m_isReverse) {
            return !bl;
        }
        return bl;
    }

    public String getSpeciesColor(String string) {
        int n;
        int n2 = n = this.speciesToNumber(string);
        if (10 < n) {
            n2 = n % 10;
        }
        if (n2 == 0) {
            n2 = 10;
        }
        return SpeciesColors[n2 - 1];
    }

    private int speciesToNumber(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        char c = Character.toUpperCase(string.charAt(0));
        switch (c) {
            case 'A': {
                return 1;
            }
            case 'B': {
                return 2;
            }
            case 'C': {
                return 3;
            }
            case 'D': {
                return 4;
            }
            case 'E': {
                return 5;
            }
            case 'F': {
                return 6;
            }
            case 'G': {
                return 7;
            }
            case 'H': {
                return 8;
            }
            case 'I': {
                return 9;
            }
            case 'J': {
                return 10;
            }
            case 'K': {
                return 11;
            }
            case 'L': {
                return 12;
            }
            case 'M': {
                return 13;
            }
            case 'N': {
                return 14;
            }
            case 'O': {
                return 15;
            }
            case 'P': {
                return 16;
            }
            case 'Q': {
                return 17;
            }
            case 'R': {
                return 18;
            }
            case 'S': {
                return 19;
            }
            case 'T': {
                return 20;
            }
            case 'U': {
                return 21;
            }
            case 'V': {
                return 22;
            }
            case 'W': {
                return 23;
            }
            case 'X': {
                return 24;
            }
            case 'Y': {
                return 25;
            }
            case 'Z': {
                return 26;
            }
        }
        return 0;
    }

    public void exec() throws Exception {
        PtreeMainWindow ptreeMainWindow = new PtreeMainWindow(this);
        ptreeMainWindow.setExitAction(1);
        ptreeMainWindow.readDnd(this.m_dndFile);
        this.m_timer = new Timer(3000, new TimerListener(this, ptreeMainWindow));
        this.m_timer.start();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage: java -jar test.jar [dnd file]");
            return;
        }
        String string = stringArray[0];
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("ERROR: file is not found.");
            return;
        }
        if (!file.isFile()) {
            System.err.println("ERROR: file is not regular file.");
            return;
        }
        try {
            Test test = new Test(string);
            test.exec();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

