/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.data.Cluster;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.search.ClusterSearchCondition;
import cgdp.recog.search.KeywordSearch;
import cgdp.recog.search.KeywordSearchResult;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ClusterLocalSearchExecuter
extends KeywordSearch {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterLocalSearchExecuter.class);
    private ClusterSearchCondition condition;
    private boolean intensive;
    private List searchResultList = new ArrayList();

    ClusterLocalSearchExecuter(ClusterSearchCondition clusterSearchCondition, boolean bl) {
        this.condition = clusterSearchCondition;
        this.intensive = bl;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            List list = new ArrayList();
            list = this.intensive ? this.searchForIntensive(progressImpl) : this.searchForExtensive(progressImpl);
            if (CollectionUtil.isNull(list)) {
                return;
            }
            if (progressImpl.isCanceled()) {
                this.clearSearchResult();
                this.setCancel(true);
                return;
            }
            for (Cluster cluster : list) {
                KeywordSearchResult keywordSearchResult = new KeywordSearchResult();
                keywordSearchResult.setCluster(cluster);
                this.searchResultList.add(keywordSearchResult);
            }
        }
        catch (Exception exception) {
            String string = "Fail to search clusters.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private List searchForIntensive(ProgressImpl progressImpl) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        Iterator iterator = this.getClusterTbl().getViewOrderList().iterator();
        while (iterator.hasNext()) {
            for (Cluster cluster : this.getClusterTbl().getViewClusterList((Map)iterator.next())) {
                boolean bl = false;
                Iterator iterator2 = this.condition.getKeywordList().iterator();
                while (iterator2.hasNext()) {
                    if (progressImpl.isCanceled()) {
                        return new ArrayList();
                    }
                    String string = (String)iterator2.next();
                    bl = this.searchClusterInfo(cluster, string);
                }
                if (!bl) continue;
                arrayList.add(cluster);
            }
            progressImpl.increment();
        }
        return arrayList;
    }

    private List searchForExtensive(ProgressImpl progressImpl) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : this.getClusterTbl().getViewClusterList()) {
            boolean bl = true;
            Iterator iterator = this.condition.getKeywordList().iterator();
            while (iterator.hasNext()) {
                if (progressImpl.isCanceled()) {
                    return new ArrayList();
                }
                String string = (String)iterator.next();
                bl &= this.searchClusterInfo(cluster, string);
            }
            if (bl) {
                arrayList.add(cluster);
            }
            progressImpl.increment();
        }
        return arrayList;
    }

    private boolean searchClusterInfo(Cluster cluster, String string) {
        switch (this.condition.getSearchTarget()) {
            case 1: {
                if (cluster.containsKeywordInGeneName(string)) {
                    return true;
                }
                if (!cluster.containsKeywordInDescription(string)) break;
                return true;
            }
            case 2: {
                if (!cluster.containsKeywordInFunctionCategory(string)) break;
                return true;
            }
        }
        return false;
    }

    private void clearSearchResult() {
        this.searchResultList.clear();
    }

    public List getSearchResultList() {
        return this.searchResultList;
    }
}

