/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

public class SearchCondType {
    public static final int EQUAL_TYPE_EQUAL = 1;
    public static final int EQUAL_TYPE_INCLUDE = 2;
    public static final int EQUAL_TYPE_FIRST = 3;
    public static final int EQUAL_TYPE_REGEXP = 4;
    public static final String COND_NEED = "+";
    public static final String COND_UNNEED = "-";
    public static final String COND_LIKE = "*";
    public static final String COND_GREATER = ">";
    public static final String COND_GREATER_EQUAL = ">=";
    public static final String COND_LESS = "<";
    public static final String COND_LESS_EQUAL = "<=";
    public static final String SERVER_COND_LIKE = "%";

    public static boolean isEqualTypeEqual(int n) {
        return n == 1;
    }

    public static boolean isEqualTypeInclude(int n) {
        return n == 2;
    }

    public static boolean isEqualTypeFirst(int n) {
        return n == 3;
    }

    public static boolean isEqualTypeRegexp(int n) {
        return n == 4;
    }

    public static boolean isNeed(String string) {
        if (string.length() <= 1) {
            return false;
        }
        if (!string.startsWith(COND_NEED)) {
            return false;
        }
        try {
            Double.parseDouble(string.substring(1));
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return string.startsWith(COND_NEED);
        }
    }

    public static boolean isUnneed(String string) {
        if (string.length() <= 1) {
            return false;
        }
        if (!string.startsWith(COND_UNNEED)) {
            return false;
        }
        try {
            Double.parseDouble(string.substring(1));
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    public static boolean isLikeSearch(String string) {
        return string.startsWith(COND_LIKE) && string.endsWith(COND_LIKE);
    }

    public static boolean isPrefixSearch(String string) {
        return !string.startsWith(COND_LIKE) && string.endsWith(COND_LIKE);
    }

    public static boolean isSuffixSearch(String string) {
        return string.startsWith(COND_LIKE) && !string.endsWith(COND_LIKE);
    }

    public static boolean isGreater(String string) {
        return !SearchCondType.isGreaterEqual(string) && string.startsWith(COND_GREATER);
    }

    public static boolean isGreaterEqual(String string) {
        return string.startsWith(COND_GREATER_EQUAL);
    }

    public static boolean isLess(String string) {
        return !SearchCondType.isLessEqual(string) && string.startsWith(COND_LESS);
    }

    public static boolean isLessEqual(String string) {
        return string.startsWith(COND_LESS_EQUAL);
    }
}

