/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.search;

import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.MultiType;
import cgdp.recog.search.SearchCondType;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class SearchConditionItem {
    private String joinKey;
    private AbstractInfoTitle infoTitle;
    private String value;
    private int multiInfoType;

    public String getJoinKey() {
        return this.joinKey;
    }

    public void setJoinKey(String string) {
        this.joinKey = string;
    }

    public AbstractInfoTitle getInfoTitle() {
        return this.infoTitle;
    }

    public int getSearchEqualType() {
        return this.getInfoTitle().getSearchEqualType();
    }

    public void setInfoTitle(AbstractInfoTitle abstractInfoTitle) {
        this.infoTitle = abstractInfoTitle;
    }

    public String getValue() {
        return this.value;
    }

    public String getAdjustValue() {
        if (this.getInfoTitle() == null) {
            return this.getValue();
        }
        if (this.getInfoTitle().equalsKey("gene") || this.getInfoTitle().equalsKey("name")) {
            String string = this.getValue();
            if (StringTool.isNull(string)) {
                return string;
            }
            if (this.getValue().endsWith("*")) {
                string = string.substring(0, string.length() - 1) + "%";
            }
            return string;
        }
        return this.getValue();
    }

    public List getKeyWordList() {
        String string = this.getValue().toLowerCase();
        return SearchConditionItem.getKeyWordList(string);
    }

    public static List getKeyWordList(String string) {
        Object object2;
        List list = StringTool.extractDoubleQuotationWords(string);
        HashSet hashSet = new HashSet();
        for (Object object2 : list) {
            hashSet.addAll(StringTool.extractWords((String)object2));
        }
        List list2 = StringTool.extractWords(string);
        object2 = new HashSet();
        Object object3 = list2.iterator();
        while (object3.hasNext()) {
            String string2 = (String)object3.next();
            if (!hashSet.contains(string2.replaceAll("\"", "").trim())) continue;
            object2.add(string2);
        }
        list2.removeAll((Collection<?>)object2);
        object3 = new ArrayList(list);
        object3.addAll(list2);
        Collections.sort((List)object3, new WordComparator());
        return object3;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public int getMultiInfoType() {
        return this.multiInfoType;
    }

    public void setMultiInfoType(int n) {
        this.multiInfoType = n;
    }

    public boolean isMultiInfoAll() {
        return MultiType.isAll(this.getMultiInfoType());
    }

    public boolean isMultiInfoAve() {
        return MultiType.isAve(this.getMultiInfoType());
    }

    public boolean isMultiInfoOnlyOne() {
        return MultiType.isOnlyOne(this.getMultiInfoType());
    }

    private static class WordComparator
    implements Comparator {
        private WordComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if (this.isPrimary(string) && !this.isPrimary(string2)) {
                return -1;
            }
            if (!this.isPrimary(string) && this.isPrimary(string2)) {
                return 1;
            }
            return string.compareTo(string2);
        }

        private boolean isPrimary(String string) {
            return SearchCondType.isNeed(string) || SearchCondType.isUnneed(string);
        }
    }
}

