/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.project.Project;
import cgdp.recog.system.Codec;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import java.io.UnsupportedEncodingException;

public abstract class AbstractServerResourceAccesser
extends SimpleServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(AbstractServerResourceAccesser.class);
    public static final String FILE_DELIMITER = "===";
    private static final String ERROR_STRING = "error";
    private static final String ERROR_ALREADY_EXIST = "already exists";
    private static final String KEY_END = "EXEC_DATE";
    private boolean error = false;
    private String message;
    private String execServer;
    private int execPort;
    private Project project;
    private boolean endParameter = false;
    private boolean checkEndParameter = false;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setCheckEndParameter(boolean bl) {
        this.checkEndParameter = bl;
    }

    protected String getServerUrl() {
        if (this.project == null) {
            return super.getServerUrl();
        }
        return this.project.getDownloadServerUrl();
    }

    public void parseOutputString(int n, String string) {
        if (this.error) {
            return;
        }
        this.parseOutputStringData(n, string);
    }

    protected void after() {
        if (this.error) {
            this.setError();
            this.setMessage(this.message);
        }
    }

    protected boolean setParameter(String string) {
        if (ServerStatus.isExecServer(string)) {
            this.execServer = ServerStatus.getExecServer(string);
            return true;
        }
        if (ServerStatus.isExecPort(string)) {
            this.execPort = ServerStatus.getExecPort(string);
            return true;
        }
        if (ServerStatus.isServerStatus(string)) {
            String string2 = ServerStatus.getServerStatus(string);
            if (!StringTool.isNull(string2) && string2.equals(ERROR_STRING)) {
                this.error = true;
            }
            return true;
        }
        if (ServerStatus.isServerStatus2(string)) {
            this.message = ServerStatus.getServerStatus2(string);
            return true;
        }
        if (ServerStatus.isExecDate(string)) {
            if (this.checkEndParameter) {
                this.endParameter = true;
            }
            return true;
        }
        return !this.endParameter && ServerStatus.isParameter(string);
    }

    protected abstract void parseOutputStringData(int var1, String var2);

    public boolean isErrorAlreadyExist() {
        return !StringTool.isNull(this.getMessage()) && this.getMessage().startsWith(ERROR_ALREADY_EXIST);
    }

    public int getExecPort() {
        return this.execPort;
    }

    public String getExecServer() {
        return this.execServer;
    }

    protected String decode(String string) {
        try {
            return Codec.decode(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.warn("Fail to decode parameter. " + string, unsupportedEncodingException);
            return string;
        }
    }
}

