/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.server;

import cgdp.recog.bean.Const;
import cgdp.recog.server.Server;
import cgdp.recog.server.ServerComparator;
import cgdp.recog.server.ServerUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class ServerTbl
extends ArrayList {
    private static final ApplicationLogger logger = new ApplicationLogger(ServerTbl.class);
    private static final String DEFAULT_SERVER_HOST = "https://mbgd.genome.ad.jp";
    private static final ServerTbl m_serverTbl = new ServerTbl();

    private ServerTbl() {
        try {
            this.readServer();
        }
        catch (IOException iOException) {
            logger.warn("Fail to read server.dat", iOException);
            MessageManager.showErrorMessage(null, "Fail to load server.dat.");
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readServer() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(Const.USER_SERVER_DAT_PATH);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (StringTool.isNull(string)) continue;
                if (string.indexOf(",") != -1) {
                    object = StringTool.splitString(string, ",");
                    string = (String)((Vector)object).get(0);
                }
                if (this.containsServer(string)) continue;
                object = new Server();
                ((Server)object).setUrl(string);
                this.add(object);
            }
            Collections.sort(this, new ServerComparator());
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public void writeServer() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (Server server : this) {
            stringBuffer.append(server.getUrl());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        FileUtil.outputFile(stringBuffer.toString(), Const.USER_SERVER_DAT_PATH);
    }

    public boolean containsServer(String string, int n) {
        String string2 = ServerUtil.combineUrlPort(string, n);
        return this.containsServer(string2);
    }

    public boolean containsServer(String string) {
        return this.getServer(string) != null;
    }

    public static boolean equalsServerUrl(String string, String string2) {
        if (StringTool.isNull(string) || StringTool.isNull(string2)) {
            return false;
        }
        return ServerUtil.modifyServerUrl(string).equals(ServerUtil.modifyServerUrl(string2));
    }

    public static boolean equalsServerUrl(String string, int n, String string2, int n2) {
        if (StringTool.isNull(string) || StringTool.isNull(string2)) {
            return false;
        }
        String string3 = ServerUtil.combineUrlPort(string, n);
        String string4 = ServerUtil.combineUrlPort(string2, n2);
        return ServerTbl.equalsServerUrl(string3, string4);
    }

    public static String[] splitUrlPort(String string) {
        String string2;
        String string3 = string;
        if (string3.startsWith("http://")) {
            string3 = string3.replaceAll("http://", "");
        }
        Vector vector = StringTool.splitString(string3, ":");
        String string4 = "80";
        if (vector.size() == 1) {
            string2 = String.valueOf(vector.get(0));
        } else {
            string2 = String.valueOf(vector.get(0));
            string4 = String.valueOf(vector.get(1));
        }
        return new String[]{string2, string4};
    }

    private Server getServer(String string) {
        for (Server server : this) {
            if (!server.equalsServer(string)) continue;
            return server;
        }
        return null;
    }

    public void updateSelectState(String string) {
        this.clearSelect();
        for (Server server : this) {
            if (!server.equalsServer(string)) continue;
            server.setSelect(true);
            break;
        }
    }

    private void clearSelect() {
        for (Server server : this) {
            server.setSelect(false);
        }
    }

    public List getServerUrlList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Server server : this) {
            arrayList.add(server.getUrl());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static ServerTbl getInstance() {
        return m_serverTbl;
    }

    public static String getDefaultServerHost() {
        return DEFAULT_SERVER_HOST;
    }

    public static String getDefaultServerHostWithoutHttp() {
        String string = ServerTbl.getDefaultServerHost();
        if (string.startsWith("http://")) {
            string = string.substring("http://".length());
        }
        return string;
    }

    public static boolean isDefaultServerHost(String string) {
        if (string.equals(ServerTbl.getDefaultServerHost())) {
            return true;
        }
        return string.endsWith("/") && (string = string.substring(0, string.length() - 1)).equals(ServerTbl.getDefaultServerHost());
    }

    public boolean addServer(String string) {
        if (this.containsServer(string)) {
            return false;
        }
        Server server = new Server();
        server.setUrl(string);
        this.add(server);
        Collections.sort(this, new ServerComparator());
        return true;
    }
}

