/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set;

import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.ElementSetGroup;
import cgdp.recog.set.SetCondition;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;

class SetConditionGroupExporter
extends FileExporter {
    private static final String TITLE_SET_CONDITION = "SetCondition";
    private static final String TITLE_ELEMENT_SET_GROUP = "ElementSetGroup";
    private static final String KEY_SET_TYPE = "#SetType";
    private static final String KEY_NAME = "#Name";
    private static final String KEY_NO_MATCH_COLOR = "#NoMatchColor";
    private static final String KEY_SYNC_ENABLE = "#SyncEnable";
    private static final String KEY_COMBINATION = "#Combination";
    private static final String KEY_COLOR = "#Color";
    private static final String KEY_ACTIVE_COLOR = "#ActiveColor";
    private static final String KEY_ACTIVE_FILTER = "#ActiveFilter";
    private static final String KEY_ELEMENT_SET = "#ElementSet";
    private static final String KEY_ELEMENT_SET_NOT_CONDITION = "#ElementSetNot";
    private static final String DELIMITER = "\t";
    private static final String DELIMTER_ELEMENT_SET = ",";
    private static final String SEP_SET_CONDITION = "////";
    private static final String SEP_ELEMENT_SET_GROUP = "//";
    private String filepath;
    private SetConditionGroup setConditionGroup;

    SetConditionGroupExporter(String string, SetConditionGroup setConditionGroup) {
        this.setConditionGroup = setConditionGroup;
        this.filepath = string;
    }

    protected String getContents() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (SetCondition setCondition : this.setConditionGroup.getSetConditionList()) {
            stringBuffer.append(this.getSetConditionStr(n, setCondition));
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getSetConditionStr(int n, SetCondition setCondition) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SetCondition\t" + (n + 1));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_SET_TYPE);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(setCondition.getSetType());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_NAME);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(setCondition.getName());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_NO_MATCH_COLOR);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(ColorUtil.color2Str(setCondition.getNoMatchColor()));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_SYNC_ENABLE);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(setCondition.isSyncEnable());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_COMBINATION);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(setCondition.isCombination());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        int n2 = 0;
        for (ElementSetGroup elementSetGroup : setCondition.getElementSetGroupList()) {
            stringBuffer.append(this.getElementSetGroupStr(n2, elementSetGroup));
            if (n2 != setCondition.getElementSetGroupList().size() - 1) {
                stringBuffer.append(SEP_ELEMENT_SET_GROUP);
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
            }
            ++n2;
        }
        stringBuffer.append(SEP_SET_CONDITION);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    private String getElementSetGroupStr(int n, ElementSetGroup elementSetGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ElementSetGroup\t" + (n + 1));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_COLOR);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(ColorUtil.color2Str(elementSetGroup.getColor()));
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_ACTIVE_COLOR);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(elementSetGroup.isColorActive());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_ACTIVE_FILTER);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(elementSetGroup.isFilterActive());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_ELEMENT_SET);
        stringBuffer.append(DELIMITER);
        int n2 = 0;
        for (AbstractElementSet abstractElementSet : elementSetGroup.getElementSetList()) {
            stringBuffer.append(abstractElementSet.getName());
            if (n2 != elementSetGroup.getElementSetCount() - 1) {
                stringBuffer.append(DELIMTER_ELEMENT_SET);
            }
            ++n2;
        }
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(KEY_ELEMENT_SET_NOT_CONDITION);
        stringBuffer.append(DELIMITER);
        n2 = 0;
        for (AbstractElementSet abstractElementSet : elementSetGroup.getElementSetList()) {
            stringBuffer.append(elementSetGroup.isNot(abstractElementSet));
            if (n2 != elementSetGroup.getElementSetCount() - 1) {
                stringBuffer.append(DELIMTER_ELEMENT_SET);
            }
            ++n2;
        }
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    protected String getFilepath() {
        return this.filepath;
    }
}

