/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.project.Project;
import cgdp.recog.server.AbstractServerResourceAccesser;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.system.URLList;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ClusterSetListDonwloader
extends AbstractServerResourceAccesser {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetListDonwloader.class);
    private static final String DELIMITER = "\t";
    private String domClustId;
    private List clusterSetList = new ArrayList();

    public ClusterSetListDonwloader(String string, Project project) {
        this.setProject(project);
        this.domClustId = string;
        this.setContextPath(URLList.getInstance().getGetClusterSetTitleList());
        this.setOptions();
    }

    public void parseOutputStringData(int n, String string) {
        Object object;
        Vector vector = StringTool.splitString(string, DELIMITER);
        if (vector.size() != 2) {
            return;
        }
        String string2 = (String)vector.get(0);
        String string3 = (String)vector.get(1);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            object = "Fail to parse element count. " + string2;
            logger.warn((String)object, numberFormatException);
        }
        ClusterSet clusterSet = new ClusterSet();
        clusterSet.setName(string2);
        clusterSet.newListFilename();
        clusterSet.setElementSize(n2);
        clusterSet.setDomClustId(this.domClustId);
        clusterSet.setLocation(this.getProject().getProjectName());
        object = (ClusterSet)ClusterSetFacade.getInstance().getSameElementSet(clusterSet);
        if (object != null) {
            clusterSet.setId(((AbstractElementSet)object).getId());
            clusterSet.setListFilename(((AbstractElementSet)object).getListFilename());
        }
        clusterSet.setLocation("Server");
        this.clusterSetList.add(clusterSet);
    }

    private void setOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tabid=");
        stringBuffer.append(this.domClustId);
        this.setOptions(stringBuffer.toString());
    }

    public List getClusterSetList() {
        return this.clusterSetList;
    }
}

