/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.cluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.info.LocationType;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerUtil;
import cgdp.recog.set.AbstractElementSet;
import cgdp.recog.set.AbstractElementSetFacade;
import cgdp.recog.set.SetDeleteAfterRunnable;
import cgdp.recog.set.SetDeleteRequestExecuter;
import cgdp.recog.set.SetTableCellRenderer;
import cgdp.recog.set.cluster.ClusterSet;
import cgdp.recog.set.cluster.ClusterSetDownloadExecuter;
import cgdp.recog.set.cluster.ClusterSetEditDialog;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.cluster.ClusterSetImportDialog;
import cgdp.recog.set.cluster.ClusterSetTableModel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.AbstractControlTabPanel;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ClusterSetTabPanel
extends AbstractControlTabPanel {
    private static final ApplicationLogger logger = new ApplicationLogger(ClusterSetTabPanel.class);
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private JTable clusterSetTable;

    public ClusterSetTabPanel(Dialog dialog, MediatorImpl mediatorImpl) {
        super(dialog);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    private void createComponents() {
        this.clusterSetTable = new JTable(new ClusterSetTableModel());
        TableColumnModel tableColumnModel = this.clusterSetTable.getColumnModel();
        for (int i = 0; i < this.clusterSetTable.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellRenderer(new SetTableCellRenderer());
        }
        this.clusterSetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClusterSetTabPanel.this.setEnabledButton();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.clusterSetTable, 20, 30);
        this.setLayout(new GridBagLayout());
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getControlButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setEnabledButton();
    }

    public void updateValue(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        List list = this.getClusterSetList(clusterTbl);
        ClusterSetTableModel clusterSetTableModel = this.getClusterSetTableModel();
        clusterSetTableModel.setElementSetList(list);
        this.setEnabledButton();
    }

    private List getClusterSetList(ClusterTbl clusterTbl) {
        List list = ClusterSetFacade.getInstance().getElementSetList();
        Project project = ProjectAccesser.getSelectedProject();
        if (project.isServer() && this.clusterTbl != null) {
            try {
                List list2 = ClusterSetFacade.downloadClusterSetList(clusterTbl, project);
                list.addAll(list2);
            }
            catch (Exception exception) {
                String string = "Fail to load cluster set from server.";
                logger.warn(string, exception);
                MessageManager.showErrorMessage(this.parent, string);
            }
        }
        return list;
    }

    private void setEnabledButton() {
        int n = this.clusterSetTable.getSelectedRow();
        super.setEnabledButton(n);
        if (n == -1) {
            this.downloadButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(this.enableDelete());
            ClusterSetTableModel clusterSetTableModel = this.getClusterSetTableModel();
            AbstractElementSet abstractElementSet = clusterSetTableModel.getElementSet(n);
            List list = this.getSelectedClusterSetList();
            if (LocationType.isNameServer(abstractElementSet.getLocation())) {
                List list2 = AbstractElementSetFacade.getServerSetList(list);
                this.downloadButton.setEnabled(list2.size() == list.size());
                this.editButton.setEnabled(true);
                this.uploadButton.setEnabled(false);
            } else {
                List list3 = AbstractElementSetFacade.getLocalSetList(list);
                List list4 = null;
                try {
                    list4 = this.filterClusterSetListByServer(list3);
                    list4 = this.filterClusterSetByDomClust(list4);
                    this.uploadButton.setEnabled(!CollectionUtil.isNull(list4) && list.size() == list4.size());
                }
                catch (IOException iOException) {
                    String string = "Fail to load dclst file.";
                    logger.warn(string, iOException);
                    this.uploadButton.setEnabled(false);
                }
                this.downloadButton.setEnabled(false);
                this.editButton.setEnabled(true);
            }
        }
    }

    private boolean enableDelete() {
        List list = this.getSelectedClusterSetList();
        if (CollectionUtil.isNull(list)) {
            return false;
        }
        List list2 = AbstractElementSetFacade.getServerSetList(list);
        return CollectionUtil.isNull(list2) || list2.size() == list.size();
    }

    private List filterClusterSetListByServer(List list) throws IOException {
        ArrayList<ClusterSet> arrayList = new ArrayList<ClusterSet>();
        for (ClusterSet clusterSet : list) {
            String string = clusterSet.getDomClustFilename();
            Project project = ProjectAccesser.getProject(clusterSet.getLocation());
            String string2 = DomClustFileUtil.createDomClustFilepath(project, string);
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(string2);
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            String string3 = abstractDomClustImporter.getExecServer();
            int n = abstractDomClustImporter.getExecPort();
            String string4 = ServerUtil.combineUrlPort(string3, n);
            if (!AccessServer.getInstance().equalsServerUrl(string4)) continue;
            arrayList.add(clusterSet);
        }
        return arrayList;
    }

    public List filterClusterSetByDomClust(List list) {
        ArrayList<ClusterSet> arrayList = new ArrayList<ClusterSet>();
        if (this.clusterTbl == null) {
            return arrayList;
        }
        Project project = ProjectAccesser.getSelectedProject();
        for (ClusterSet clusterSet : list) {
            if (!clusterSet.equalsDomClustId(this.clusterTbl.getClusterId()) || !clusterSet.equalsLocation(project.getProjectName())) continue;
            arrayList.add(clusterSet);
        }
        return arrayList;
    }

    private List getSelectedClusterSetList() {
        ArrayList<ClusterSet> arrayList = new ArrayList<ClusterSet>();
        int[] nArray = this.clusterSetTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return arrayList;
        }
        ClusterSetTableModel clusterSetTableModel = this.getClusterSetTableModel();
        for (int i = 0; i < nArray.length; ++i) {
            ClusterSet clusterSet = clusterSetTableModel.getClusterSet(nArray[i]);
            arrayList.add(clusterSet);
        }
        return arrayList;
    }

    private ClusterSetTableModel getClusterSetTableModel() {
        ClusterSetTableModel clusterSetTableModel = (ClusterSetTableModel)this.clusterSetTable.getModel();
        return clusterSetTableModel;
    }

    protected void add() {
        Project project = ProjectAccesser.getSelectedProject();
        ClusterSetImportDialog clusterSetImportDialog = ClusterSetImportDialog.getInstanse(this.parent);
        clusterSetImportDialog.updateValue(project.getProjectName(), this.clusterTbl, true);
        clusterSetImportDialog.setVisible(true);
        if (clusterSetImportDialog.isCanceled()) {
            return;
        }
        ClusterSet clusterSet = clusterSetImportDialog.createClusterSet();
        clusterSet.setNew();
        String string = clusterSetImportDialog.getFilepath();
        List list = null;
        try {
            list = ClusterSetFacade.getClusterListFromUserFile(string, this.clusterTbl);
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), iOException);
            MessageManager.showErrorMessage((Component)this, iOException.getMessage());
            return;
        }
        clusterSet.setElementList(list);
        ClusterSetTableModel clusterSetTableModel = this.getClusterSetTableModel();
        clusterSetTableModel.add(clusterSet);
    }

    protected void edit() {
        Object object;
        int n = this.clusterSetTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        ClusterSetTableModel clusterSetTableModel = this.getClusterSetTableModel();
        ClusterSet clusterSet = clusterSetTableModel.getClusterSet(n);
        if (!clusterSet.isExistElement()) {
            object = ClusterSetFacade.getInstance().importElementList(clusterSet);
            clusterSet.setElementList((List)object);
        }
        object = ClusterSetEditDialog.getInstance();
        ((ClusterSetEditDialog)object).updateValue(clusterSet, this.clusterTbl);
        ((Dialog)object).setVisible(true);
        if (((AbstractApplyDialog)object).isCanceled()) {
            return;
        }
        ClusterSet clusterSet2 = ((ClusterSetEditDialog)object).createClusterSet();
        clusterSet.copy(clusterSet2);
        clusterSet.setStatus(clusterSet2.getStatus());
        clusterSetTableModel.updateElementSetList();
    }

    protected void delete() {
        if (!this.enableDelete()) {
            return;
        }
        List list = this.getSelectedClusterSetList();
        List list2 = AbstractElementSetFacade.getServerSetList(list);
        List list3 = AbstractElementSetFacade.getLocalSetList(list);
        if (list.size() == list2.size()) {
            Object[] objectArray = new String[]{"Delete the following sets?", AbstractElementSetFacade.getElementSetNameString(list2)};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            SetDeleteRequestExecuter setDeleteRequestExecuter = new SetDeleteRequestExecuter(this.parent, list2);
            setDeleteRequestExecuter.setAfterRunnable(new SetDeleteAfterRunnable(){

                public void run() {
                    ClusterSetTabPanel.this.updateValue(ClusterSetTabPanel.this.clusterTbl);
                }
            });
            new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Delete cluster set...", false, (ProcessImpl)setDeleteRequestExecuter);
        } else if (list.size() == list3.size()) {
            int[] nArray = this.clusterSetTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            ClusterSetTableModel clusterSetTableModel = this.getClusterSetTableModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                ClusterSet clusterSet = clusterSetTableModel.getClusterSet(nArray[i]);
                stringBuffer.append(clusterSet.getName());
                if (i == nArray.length - 1) continue;
                stringBuffer.append(",");
            }
            Object[] objectArray = new String[]{"Delete the following cluster sets?", stringBuffer.toString()};
            if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
                return;
            }
            clusterSetTableModel.remove(nArray);
        }
    }

    protected void download() {
        List list = this.getSelectedClusterSetList();
        List list2 = AbstractElementSetFacade.getServerSetList(list);
        Object[] objectArray = new String[]{"Download the following cluster sets?", AbstractElementSetFacade.getElementSetNameString(list2)};
        if (!MessageManager.showConfirmMessage((Component)this, objectArray)) {
            return;
        }
        List list3 = ClusterSetFacade.convertServerToLocalSet(list2);
        if (!AbstractElementSetFacade.validateSet(this, list3)) {
            return;
        }
        Project project = ProjectAccesser.getSelectedProject();
        ClusterSetDownloadExecuter clusterSetDownloadExecuter = new ClusterSetDownloadExecuter(this, list3, this.clusterTbl, project);
        clusterSetDownloadExecuter.setAfterRunnable(new Runnable(){

            public void run() {
                ClusterSetTabPanel.this.updateValue(ClusterSetTabPanel.this.clusterTbl);
                ClusterSetTabPanel.this.mediator.updateClusterSetTree();
            }
        });
        new ProgressDialog((Dialog)this.parent, this.mediator, 1, "Download cluster set...", false, (ProcessImpl)clusterSetDownloadExecuter);
    }

    protected void upload() {
        List list = this.getSelectedClusterSetList();
        Runnable runnable = new Runnable(){

            public void run() {
                ClusterSetTabPanel.this.updateValue(ClusterSetTabPanel.this.clusterTbl);
            }
        };
        this.mediator.uploadClusterSet(this.parent, list, runnable);
    }

    protected void changeDefault() {
    }

    public boolean check() {
        return true;
    }

    protected void updateParameters() {
        try {
            ClusterSetTableModel clusterSetTableModel = this.getClusterSetTableModel();
            List list = clusterSetTableModel.getElementSetList();
            ClusterSetFacade.getInstance().registerElementSetList(list);
            this.mediator.updateClusterSetTree();
        }
        catch (Exception exception) {
            String string = "Fail to register cluster sets.";
            logger.warn("Fail to register cluster sets.", exception);
            MessageManager.showErrorMessage((Component)this, string);
        }
    }
}

