/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.set.gene;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

class GeneSetEditItem
extends JMenuItem
implements CommandImpl {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneSetEditItem.class);
    private Component parent;
    private MediatorImpl mediator;
    private GeneSet geneSet;

    GeneSetEditItem(ActionListener actionListener, Component component, MediatorImpl mediatorImpl, GeneSet geneSet) {
        super("Edit gene set [" + geneSet.getName() + "]...");
        this.parent = component;
        this.mediator = mediatorImpl;
        this.geneSet = geneSet;
        this.addActionListener(actionListener);
    }

    public void execute() {
        try {
            GeneSetFacade.getInstance().editGeneSet(this.mediator, this.geneSet);
        }
        catch (Exception exception) {
            String string = "Fail to edit gene set.";
            logger.warn(string, exception);
            MessageManager.showErrorMessage(this.parent, string);
        }
    }
}

