/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.statusbar;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.SingleTaskManager;
import cgdp.recog.statusbar.MemoryArea;
import cgdp.recog.system.OS;
import cgdp.recog.update.VersionUpTask;
import cgdp.recog.util.JLicenserTool;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StatusBar
extends JPanel
implements ActionListener {
    private MediatorImpl mediator;
    private MemoryArea memoryArea;
    private JLabel taxonomyCountLabel;
    private JLabel patternCountLabel;
    private JButton infoButton;
    private List infoRunList = new ArrayList();
    private JLabel progressLabel;
    private int rightMargin = 0;

    public StatusBar(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.init();
    }

    private void init() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 1));
        this.memoryArea = new MemoryArea(this.mediator);
        this.taxonomyCountLabel = new JLabel();
        this.patternCountLabel = new JLabel();
        this.infoButton = new JButton();
        try {
            this.infoButton.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/info2.png")));
            this.infoButton.setMargin(new Insets(0, 0, 0, 0));
        }
        catch (Exception exception) {
            this.infoButton.setText("Info");
        }
        this.infoButton.setVisible(false);
        this.infoButton.addActionListener(this);
        jPanel.add(this.memoryArea);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.taxonomyCountLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.patternCountLabel);
        this.progressLabel = this.createProgressLabel();
        if (OS.isMac()) {
            this.rightMargin = 20;
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.progressLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, this.rightMargin), 0, 0));
        this.add((Component)this.infoButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, this.rightMargin), 0, 0));
    }

    public void setVisibledProgressLabel(boolean bl) {
        this.progressLabel.setVisible(bl);
    }

    private JLabel createProgressLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setVisible(false);
        try {
            jLabel.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/progress.gif")));
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    SingleTaskManager singleTaskManager = SingleTaskManager.getInstance();
                    if (singleTaskManager.isExecuteTask()) {
                        StatusBar.this.setVisibledProgressLabel(false);
                        singleTaskManager.getProgressDialog().setVisible(true);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jLabel;
    }

    public void showTaxonomyCount() {
        this.taxonomyCountLabel.setText("Number of Genomes: " + this.mediator.getTaxonomyCount());
    }

    public void addInfoRunTask(Runnable runnable) {
        VersionUpTask versionUpTask;
        if (runnable instanceof VersionUpTask && (versionUpTask = this.indexOfRunTask((VersionUpTask)runnable)) != null) {
            this.infoRunList.remove(versionUpTask);
        }
        this.infoRunList.add(runnable);
        this.infoButton.setVisible(true);
    }

    private VersionUpTask indexOfRunTask(VersionUpTask versionUpTask) {
        for (Runnable runnable : this.infoRunList) {
            VersionUpTask versionUpTask2;
            if (!(runnable instanceof VersionUpTask) || !(versionUpTask2 = (VersionUpTask)runnable).equalsTask(versionUpTask)) continue;
            return versionUpTask2;
        }
        return null;
    }

    public void showPatternCount() {
        String string = "Number of Clusters";
        OptionTbl optionTbl = OptionTbl.getInstance();
        string = optionTbl.getOptionValues().isIntensive() ? string + (this.mediator.isLimitNoListForAggregate() ? " (Limited): " : ": ") : string + (this.mediator.isLimitNoListForDisaggregate() ? " (Limited): " : ": ");
        this.patternCountLabel.setText(string + this.mediator.getViewCount());
    }

    public void updateMemory() {
        this.memoryArea.repaint();
    }

    public void clearInfo() {
        this.taxonomyCountLabel.setText("");
        this.patternCountLabel.setText("");
    }

    private boolean isInfo() {
        return !this.infoRunList.isEmpty();
    }

    private void showInfo() {
        if (!this.isInfo()) {
            return;
        }
        Runnable runnable = (Runnable)this.infoRunList.get(0);
        SwingUtilities.invokeLater(runnable);
        this.infoRunList.remove(runnable);
        this.updateInfoButtonStatus();
    }

    private void updateInfoButtonStatus() {
        this.infoButton.setVisible(this.isInfo());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.infoButton) {
            this.showInfo();
        }
    }
}

