/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.table;

import cgdp.recog.data.Gene;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class GeneNameTableModel
extends AbstractTableModel {
    private static String[] COLUMN_NAMES = new String[]{"Organism", "Locus Tag"};
    private List geneList = new ArrayList();

    public GeneNameTableModel(List list) {
        this.geneList = list;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getRowCount() {
        return this.geneList.size();
    }

    public Object getValueAt(int n, int n2) {
        Gene gene = (Gene)this.geneList.get(n);
        if (n2 == 0) {
            return gene.getOrganism();
        }
        if (n2 == 1) {
            return gene.getLocusTag();
        }
        return "";
    }

    public Gene getGene(int n) {
        return this.getGene(n);
    }

    public Gene getGeneByOrganism(String string) {
        int n = this.getRowIndexByOrganism(string);
        if (n == -1) {
            return null;
        }
        return (Gene)this.geneList.get(n);
    }

    public int getRowIndexByOrganism(String string) {
        int n = -1;
        if (StringTool.isNull(string)) {
            return n;
        }
        int n2 = 0;
        for (Gene gene : this.geneList) {
            if (!StringTool.isNull(gene.getOrganism()) && gene.getOrganism().equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public Gene getGeneByGeneName(String string) {
        int n = this.getRowIndexByGeneName(string);
        if (n == -1) {
            return null;
        }
        return (Gene)this.geneList.get(n);
    }

    public int getRowIndexByGeneName(String string) {
        int n = -1;
        if (StringTool.isNull(string)) {
            return n;
        }
        int n2 = 0;
        for (Gene gene : this.geneList) {
            if (!StringTool.isNull(gene.getLocusTag()) && gene.getLocusTag().equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }
}

