/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy;

import cgdp.recog.data.RankDif;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RankCheckBoxPanel
extends JPanel
implements ActionListener {
    private JRadioButton allButton;
    private JRadioButton simpleButton;
    private Map taxRankCheckBoxMap = new LinkedHashMap();

    public RankCheckBoxPanel() {
        this.init();
    }

    private void init() {
        int n;
        this.allButton = new JRadioButton("All");
        this.allButton.addActionListener(this);
        this.simpleButton = new JRadioButton("Simple");
        this.simpleButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allButton);
        buttonGroup.add(this.simpleButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.allButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.simpleButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        String[] stringArray = RankDif.RANKS;
        for (n = 0; n < stringArray.length; ++n) {
            JCheckBox jCheckBox = new JCheckBox(stringArray[n]);
            this.taxRankCheckBoxMap.put(stringArray[n], jCheckBox);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        n = 1;
        int n2 = 0;
        for (JCheckBox jCheckBox : this.taxRankCheckBoxMap.values()) {
            this.add((Component)jCheckBox, new GridBagConstraints(n2, n, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            if (++n2 % 5 != 0) continue;
            n2 = 0;
            ++n;
        }
    }

    public void updateValue(boolean bl, Set set) {
        this.allButton.setSelected(bl);
        this.simpleButton.setSelected(!bl);
        this.setRankCheckBoxEnabled(!bl);
        for (String string : this.taxRankCheckBoxMap.keySet()) {
            JCheckBox jCheckBox = (JCheckBox)this.taxRankCheckBoxMap.get(string);
            jCheckBox.setSelected(set.contains(string));
        }
    }

    public boolean isAllRank() {
        return this.allButton.isSelected();
    }

    public Set getSelectedRankSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.taxRankCheckBoxMap.keySet()) {
            JCheckBox jCheckBox = (JCheckBox)this.taxRankCheckBoxMap.get(string);
            if (!jCheckBox.isSelected()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private void setRankCheckBoxEnabled(boolean bl) {
        for (JCheckBox jCheckBox : this.taxRankCheckBoxMap.values()) {
            jCheckBox.setEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.allButton) {
            this.setRankCheckBoxEnabled(false);
        } else if (actionEvent.getSource() == this.simpleButton) {
            this.setRankCheckBoxEnabled(true);
        }
    }
}

