/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.TaxMapUtil;
import javax.swing.table.AbstractTableModel;
import org.jfree.data.general.PieDataset;

class PieDatasetTableModel
extends AbstractTableModel {
    private static final String[] COLUMNS = new String[]{"Name", "Value", "Ratio"};
    private PieDataset pieDataset;
    private float sum;

    PieDatasetTableModel() {
    }

    public void setPieDataset(PieDataset pieDataset) {
        this.pieDataset = pieDataset;
        this.sum = TaxMapUtil.calcSum(pieDataset);
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return COLUMNS.length;
    }

    public int getRowCount() {
        return this.pieDataset.getItemCount();
    }

    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    public Class getColumnClass(int n) {
        if (n == 1 || n == 2) {
            return Number.class;
        }
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return (String)((Object)this.pieDataset.getKey(n));
        }
        if (n2 == 1) {
            return this.pieDataset.getValue(n);
        }
        if (n2 == 2) {
            float f = this.pieDataset.getValue(n).floatValue();
            return new Float(f / this.sum);
        }
        return null;
    }
}

