/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.filefilter.SingleFileFilter;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.process.ProcessImpl;
import cgdp.recog.process.ProgressDialog;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.taxonomy.DisplayTaxonomyTreeNode;
import cgdp.recog.taxonomy.TaxFacade;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.AbstractRankScoreCalculater;
import cgdp.recog.taxonomy.map.GeneScoreModeItem;
import cgdp.recog.taxonomy.map.RankChangeEvent;
import cgdp.recog.taxonomy.map.SyncPPMFilterItem;
import cgdp.recog.taxonomy.map.SyncPPMSelectItem;
import cgdp.recog.taxonomy.map.TaxMapAddPropertyItem;
import cgdp.recog.taxonomy.map.TaxMapAggregateItem;
import cgdp.recog.taxonomy.map.TaxMapDisplayModeItem;
import cgdp.recog.taxonomy.map.TaxMapDisplayRankModeMenu;
import cgdp.recog.taxonomy.map.TaxMapFacade;
import cgdp.recog.taxonomy.map.TaxMapFilterScoreItem;
import cgdp.recog.taxonomy.map.TaxMapGraphPanel;
import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.taxonomy.map.TaxMapInfoTable;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapOptionDialog;
import cgdp.recog.taxonomy.map.TaxMapOptionItem;
import cgdp.recog.taxonomy.map.TaxMapPopulationPanel;
import cgdp.recog.taxonomy.map.TaxMapScoreCalcItem;
import cgdp.recog.taxonomy.map.TaxMapShowAllNodeItem;
import cgdp.recog.taxonomy.map.TaxMapShowMappingNodeItem;
import cgdp.recog.taxonomy.map.TaxMapUtil;
import cgdp.recog.taxonomy.map.TaxMapViewHandler;
import cgdp.recog.taxonomy.map.TaxTreeChangeEvent;
import cgdp.recog.taxonomy.map.TaxTreePanel;
import cgdp.recog.util.ApplicationFrame;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class TaxMapFrame
extends ApplicationFrame
implements ActionListener,
ApplicationObserver,
MenuListener {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapFrame.class);
    private static final String TITLE = "Taxonomy Mapping";
    private Frame parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private TaxMapModel taxMapModel = new TaxMapModel();
    private TaxTreePanel taxTreePanel;
    private TaxMapPopulationPanel taxMapPopulationPanel;
    private TaxMapGraphPanel taxMapGraphPanel;
    private JFileChooser chooser;
    private JLabel tableTitleLabel;
    private TaxMapInfoTable taxMapInfoTable;
    private JButton geneSetButton;
    private JButton exportButton;
    private JButton closeButton;
    private JMenu viewMenu;
    private GeneScoreModeItem geneCountLowerModeItem;
    private GeneScoreModeItem geneCountUpperModeItem;
    private GeneScoreModeItem geneScoreLowerModeItem;
    private GeneScoreModeItem geneScoreUpperModeItem;
    private TaxMapAggregateItem noAggregateItem;
    private TaxMapAggregateItem maxScoreItem;
    private TaxMapAggregateItem scoringItem;
    private SyncPPMSelectItem syncPPMSelectItem;
    private SyncPPMFilterItem syncPPMFilterItem;
    private TaxMapDisplayModeItem actionModeItem;
    private TaxMapDisplayModeItem viewModeItem;
    private TaxMapDisplayRankModeMenu taxMapDisplayRankModeMenu;
    private Set taxMapViewHandlerSet = new HashSet();

    private TaxMapFrame(Frame frame, MediatorImpl mediatorImpl) {
        super(TITLE);
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.init();
        TaxMapOptionDialog.createInstance(this);
    }

    public static final TaxMapFrame getInstance(Frame frame, MediatorImpl mediatorImpl) {
        return new TaxMapFrame(frame, mediatorImpl);
    }

    private void init() {
        this.taxMapModel.addObserver(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TaxMapFrame.this.exit();
            }
        });
        this.chooser = new JFileChooser();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(FileFilterFactory.createTextFileWithDirFilter());
        this.setJMenuBar(this.createMenuBar());
        this.taxTreePanel = new TaxTreePanel(this, this.mediator, this.taxMapModel);
        this.taxMapViewHandlerSet.add(this.taxTreePanel);
        this.taxMapModel.addObserver(this.taxTreePanel);
        JScrollPane jScrollPane = new JScrollPane(this.taxTreePanel, 20, 30);
        jScrollPane.getViewport().setPreferredSize(new Dimension(600, 200));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Taxonomy Tree"));
        JPanel jPanel = this.createPopulationPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Gene Population"));
        JPanel jPanel2 = this.createGraphPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Property Graph"));
        JPanel jPanel3 = this.createTablePanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Mapping Information"));
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        jSplitPane.setOneTouchExpandable(true);
        JSplitPane jSplitPane2 = new JSplitPane(0, jScrollPane, jSplitPane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerLocation(220);
        JSplitPane jSplitPane3 = new JSplitPane(0, jSplitPane2, jPanel3);
        jSplitPane3.setOneTouchExpandable(true);
        jSplitPane3.setDividerLocation(450);
        this.getContentPane().add((Component)jSplitPane3, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 15, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createGraphPanel() {
        this.taxMapGraphPanel = new TaxMapGraphPanel(this, this.mediator, this.taxMapModel);
        this.taxMapGraphPanel.setTaxMapModel(this.taxMapModel);
        this.taxMapViewHandlerSet.add(this.taxMapGraphPanel);
        this.taxMapModel.addObserver(this.taxMapGraphPanel);
        this.taxMapGraphPanel.setPreferredSize(new Dimension(400, 150));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.taxMapGraphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createPopulationPanel() {
        this.taxMapPopulationPanel = new TaxMapPopulationPanel(this, this.mediator);
        this.taxMapPopulationPanel.setTaxMapModel(this.taxMapModel);
        this.taxMapViewHandlerSet.add(this.taxMapPopulationPanel);
        this.taxMapModel.addObserver(this.taxMapPopulationPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.taxMapPopulationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createTablePanel() {
        this.tableTitleLabel = new JLabel();
        this.tableTitleLabel.setFont(TaxMapModel.TITLE_FONT);
        this.exportButton = new JButton("Export");
        this.exportButton.addActionListener(this);
        this.geneSetButton = new JButton("Create gene set");
        this.geneSetButton.addActionListener(this);
        this.taxMapInfoTable = new TaxMapInfoTable(this.mediator, this.taxMapModel);
        this.taxMapInfoTable.getViewport().setPreferredSize(new Dimension(400, 100));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.tableTitleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        jPanel.add((Component)this.geneSetButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 10), 0, 0));
        jPanel.add((Component)this.exportButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)this.taxMapInfoTable, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(Collection collection, List list, ClusterTbl clusterTbl) throws Exception {
        this.clusterTbl = clusterTbl;
        this.taxMapModel.setDomClustId(this.clusterTbl.getClusterId());
        this.taxMapGraphPanel.setClusterTbl(this.clusterTbl);
        String string = clusterTbl.getClusterId();
        ApplicationPropertyFacade.updateDomClustAccessable(string, this.taxMapModel);
        if (this.taxMapModel.getTaxMapConf() == null) {
            this.taxMapModel.setTaxMapConf(TaxMapFacade.getDefaultTaxMapConf(string));
        }
        HashSet hashSet = new HashSet(list);
        hashSet.removeAll(this.taxMapModel.getBaseMappingOrganismCodeSet());
        List list2 = TaxMapFacade.getTaxMapInfoList(string, collection, true);
        this.taxMapModel.setTaxMapInfoList(list2);
        this.syncPPMSelectItem.setSelected(this.taxMapModel.isSyncPPMSelect());
        this.syncPPMFilterItem.setSelected(this.taxMapModel.isSyncPPMFilter());
        TaxMapModelUpdater taxMapModelUpdater = new TaxMapModelUpdater(collection, list2, hashSet);
        new ProgressDialog((Frame)this, this.mediator, 1, "Update Taxonomy Mapping View...", false, (ProcessImpl)taxMapModelUpdater);
    }

    void updateValue() throws Exception {
        TaxMapModelUpdater taxMapModelUpdater = new TaxMapModelUpdater(this.taxMapModel.getMappingOrganismCodeSet(), this.taxMapModel.getTaxMapInfoList(), this.taxMapModel.getTreeOrganismCodeSet());
        new ProgressDialog((Frame)this, this.mediator, 1, "Update Taxonomy Mapping View...", false, (ProcessImpl)taxMapModelUpdater);
    }

    private void updateTaxModel(Collection collection, List list, Set set, ProgressImpl progressImpl) throws Exception {
        Object object;
        Object object22;
        progressImpl.setTotal(7);
        List list2 = TaxFacade.getDisplayTaxonomyTreeNodeList();
        Map map = TaxFacade.createRankNodeSetMap(list2);
        progressImpl.increment();
        AbstractRankScoreCalculater abstractRankScoreCalculater = AbstractRankScoreCalculater.createInstance(list, this.taxMapModel);
        abstractRankScoreCalculater.execute(progressImpl);
        progressImpl.increment();
        Map map2 = abstractRankScoreCalculater.getRankTaxMapInfoMap();
        List list3 = abstractRankScoreCalculater.getUnassignedTaxMapInfoList();
        Map map3 = abstractRankScoreCalculater.getRankScoreMap();
        Map map4 = abstractRankScoreCalculater.getParentRankScoreMap();
        Map map5 = abstractRankScoreCalculater.getChildRankScoreMap();
        progressImpl.increment();
        ArrayList arrayList = new ArrayList();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (Object object22 : collection) {
            try {
                object = new GeneTbl((String)object22);
                ((GeneTbl)object).read();
                arrayList.addAll(TaxMapFacade.getNoHitTaxMapInfoList((String)object22, (GeneTbl)object, list));
                hashMap.put(object22, new Integer(((HashMap)object).size()));
            }
            catch (Exception exception) {
                logger.warn("Fail to load the gene information. " + (String)object22, exception);
            }
        }
        for (Object object22 : arrayList) {
            String string;
            object = ((TaxMapInfo)object22).getOrganismCode();
            Cluster cluster = this.clusterTbl.getCluster((String)object, string = ((TaxMapInfo)object22).getLocusTag());
            if (cluster != null) {
                ((TaxMapInfo)object22).setClusterId(cluster.getClusterId());
                if (!this.clusterTbl.isOutgroup()) continue;
                ((TaxMapInfo)object22).setSubClusterId(cluster.getSubClusterId());
                continue;
            }
            ((TaxMapInfo)object22).setClusterId(-1);
        }
        TaxMapFacade.setClusterId(arrayList, this.clusterTbl);
        map2.put("nohits", arrayList);
        map3.put("nohits", new Double(arrayList.size()));
        progressImpl.increment();
        TaxonomyTreeNode taxonomyTreeNode = TaxMapFacade.createTargetTaxonomyTree(list2, set, this.taxMapModel);
        taxonomyTreeNode.add(TaxMapModel.createNoHitNode());
        TaxMapFacade.hideNoMappingNode((DisplayTaxonomyTreeNode)taxonomyTreeNode, map2.keySet());
        progressImpl.increment();
        object22 = TaxMapFacade.createTaxonomyTreeNodeMap(taxonomyTreeNode);
        progressImpl.increment();
        this.taxMapModel.setRootNode(taxonomyTreeNode);
        this.taxMapModel.setTreeOrganismCodeSet(set);
        this.taxMapModel.setKeyNodeMap((Map)object22);
        this.taxMapModel.setRankNodeSetMap(map);
        this.taxMapModel.setRankTaxMapInfoMap(map2);
        this.taxMapModel.setRankScoreMap(map3);
        this.taxMapModel.setParentRankScoreMap(map4);
        this.taxMapModel.setChildRankScoreMap(map5);
        this.taxMapModel.setGeneCountMap(hashMap);
        this.taxMapModel.setMappingOrganismCodeSet(new HashSet(collection));
        this.taxMapModel.setUnassignedTaxMapInfoList(list3);
        GeneInfoFacade.registerScore(this.taxMapModel);
        progressImpl.increment();
    }

    public void updateGUI() {
        this.taxMapPopulationPanel.updateValue();
        this.taxMapGraphPanel.updateValue();
        this.taxMapInfoTable.updateValue(this.clusterTbl);
        this.tableTitleLabel.setText(this.taxMapModel.getSelectNodeName());
        this.taxMapInfoTable.setTaxMapInfoList(this.taxMapModel.getTaxMapInfoList());
        this.updateModeItem();
        this.updateAggregateItem();
        this.updateDisplayModeItem();
        this.repaint();
    }

    private void updateModeItem() {
        if (this.taxMapModel.isModeScoreLower()) {
            this.geneScoreLowerModeItem.setSelected(true);
        } else if (this.taxMapModel.isModeScoreUpper()) {
            this.geneScoreUpperModeItem.setSelected(true);
        } else if (this.taxMapModel.isModeGeneCountUpper()) {
            this.geneCountUpperModeItem.setSelected(true);
        } else if (this.taxMapModel.isModeGeneCountLower()) {
            this.geneCountLowerModeItem.setSelected(true);
        } else {
            this.geneScoreLowerModeItem.setSelected(true);
        }
    }

    private void updateAggregateItem() {
        if (this.taxMapModel.isAggregateMaxScoreInfo()) {
            this.maxScoreItem.setSelected(true);
        } else if (this.taxMapModel.isAggregateScoring()) {
            this.scoringItem.setSelected(true);
        } else {
            this.noAggregateItem.setSelected(true);
        }
    }

    private void updateDisplayModeItem() {
        if (this.taxMapModel.isActionMode()) {
            this.actionModeItem.setSelected(true);
        } else {
            this.viewModeItem.setSelected(true);
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.viewMenu = new JMenu("View");
        this.viewMenu.addMenuListener(this);
        jMenuBar.add(this.viewMenu);
        this.geneCountLowerModeItem = new GeneScoreModeItem(this, this, this.taxMapModel, "Gene Count(Lower)", 3);
        this.geneCountUpperModeItem = new GeneScoreModeItem(this, this, this.taxMapModel, "Gene Count(Upper)", 4);
        this.geneScoreLowerModeItem = new GeneScoreModeItem(this, this, this.taxMapModel, "Cumulative Count(Lower)", 1);
        this.geneScoreUpperModeItem = new GeneScoreModeItem(this, this, this.taxMapModel, "Cumulative Count(Upper)", 2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.geneCountLowerModeItem);
        buttonGroup.add(this.geneCountUpperModeItem);
        buttonGroup.add(this.geneScoreLowerModeItem);
        buttonGroup.add(this.geneScoreUpperModeItem);
        this.viewMenu.add(this.geneCountLowerModeItem);
        this.viewMenu.add(this.geneCountUpperModeItem);
        this.viewMenu.add(this.geneScoreLowerModeItem);
        this.viewMenu.add(this.geneScoreUpperModeItem);
        this.viewMenu.addSeparator();
        this.noAggregateItem = new TaxMapAggregateItem(this, this, this.taxMapModel, 1, "No Aggregate");
        this.maxScoreItem = new TaxMapAggregateItem(this, this, this.taxMapModel, 2, "Max Score");
        this.scoringItem = new TaxMapAggregateItem(this, this, this.taxMapModel, 3, "Scoring");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.noAggregateItem);
        buttonGroup2.add(this.maxScoreItem);
        buttonGroup2.add(this.scoringItem);
        JMenu jMenu = new JMenu("Aggregate Type");
        jMenu.add(this.noAggregateItem);
        jMenu.add(this.maxScoreItem);
        jMenu.add(this.scoringItem);
        this.viewMenu.add(jMenu);
        this.viewMenu.addSeparator();
        this.taxMapDisplayRankModeMenu = new TaxMapDisplayRankModeMenu(this.taxMapModel);
        this.viewMenu.add(this.taxMapDisplayRankModeMenu);
        this.viewMenu.addSeparator();
        this.viewMenu.add(new TaxMapShowAllNodeItem(this, this.taxMapModel));
        this.viewMenu.add(new TaxMapShowMappingNodeItem(this, this.taxMapModel));
        this.viewMenu.addSeparator();
        this.actionModeItem = new TaxMapDisplayModeItem(this, this.taxMapModel, "Action Mode", 1);
        this.viewModeItem = new TaxMapDisplayModeItem(this, this.taxMapModel, "View Mode", 2);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.actionModeItem);
        buttonGroup3.add(this.viewModeItem);
        this.viewMenu.add(this.actionModeItem);
        this.viewMenu.add(this.viewModeItem);
        this.viewMenu.addSeparator();
        this.syncPPMSelectItem = new SyncPPMSelectItem(this, this.taxMapModel);
        this.syncPPMFilterItem = new SyncPPMFilterItem(this, this.taxMapModel);
        this.viewMenu.add(this.syncPPMSelectItem);
        this.viewMenu.add(this.syncPPMFilterItem);
        JMenu jMenu2 = new JMenu("Property");
        jMenuBar.add(jMenu2);
        jMenu2.add(new TaxMapAddPropertyItem(this, this.mediator, this, "Register the mapping gene's property...", null, this.taxMapModel));
        jMenu2.add(new TaxMapScoreCalcItem(this, this.mediator, this.taxMapModel));
        JMenu jMenu3 = new JMenu("Tool");
        jMenuBar.add(jMenu3);
        jMenu3.add(new TaxMapFilterScoreItem(this, this, this.taxMapModel));
        JMenu jMenu4 = new JMenu("Option");
        jMenuBar.add(jMenu4);
        jMenu4.add(new TaxMapOptionItem(this, this, this.taxMapModel));
        return jMenuBar;
    }

    private void createGeneSet() {
        List list = this.taxMapInfoTable.getTaxMapInfoList();
        List list2 = TaxMapUtil.createGeneInfoList(list);
        Project project = ProjectAccesser.getSelectedProject();
        this.mediator.registerSetByGeneInfo(this, 14, project.getProjectName(), list2);
    }

    private void export() {
        try {
            OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
            String string = optionValues.getUserExportDir();
            this.chooser.setCurrentDirectory(new File(string));
            if (this.chooser.showSaveDialog(this) != 0) {
                return;
            }
            File file = this.chooser.getSelectedFile();
            SingleFileFilter singleFileFilter = (SingleFileFilter)this.chooser.getFileFilter();
            String string2 = singleFileFilter.modifiedExtension(file);
            if (new File(string2).isFile() && !MessageManager.showConfirmOverwriteMessage(this, new File(string2).getName())) {
                return;
            }
            List list = this.taxMapInfoTable.getTaxMapInfoList();
            TaxMapFacade.exportTaxMapInfoList(string2, list);
            optionValues.setUserExportDir(new File(string2).getParent());
        }
        catch (IOException iOException) {
            logger.warn("Fail to export the taxonomy mapping information.", iOException);
        }
    }

    private void closeView() {
        for (TaxMapViewHandler taxMapViewHandler : this.taxMapViewHandlerSet) {
            taxMapViewHandler.disposeView();
        }
    }

    public void exit() {
        this.closeView();
        this.mediator.removeTaxMapFrame(this);
        TaxMapFacade.saveTaxMapModel(this.taxMapModel);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof CommandImpl) {
            ((CommandImpl)actionEvent.getSource()).execute();
        } else if (actionEvent.getSource() == this.geneSetButton) {
            this.createGeneSet();
        } else if (actionEvent.getSource() == this.exportButton) {
            this.export();
        } else if (actionEvent.getSource() == this.closeButton) {
            this.exit();
        }
    }

    public void update(Observable observable, Object object) {
        ApplicationObserverEvent applicationObserverEvent = (ApplicationObserverEvent)object;
        if (applicationObserverEvent.getSource() == this) {
            return;
        }
        if (applicationObserverEvent instanceof RankChangeEvent) {
            List list = this.taxMapModel.getSelectNodeTaxMapInfoList();
            this.tableTitleLabel.setText(this.taxMapModel.getSelectNodeName());
            this.taxMapInfoTable.setTaxMapInfoList(list);
        } else if (applicationObserverEvent instanceof TaxTreeChangeEvent) {
            try {
                this.taxMapModel.setSelectNode(null);
                this.updateValue();
            }
            catch (Exception exception) {
                logger.warn("Fail to update Taxonomy Tree Information.", exception);
            }
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        if (menuEvent.getSource() == this.viewMenu) {
            this.updateDisplayModeItem();
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    private class TaxMapModelUpdater
    extends AbstractThreadProcess {
        private Collection mappingOrganismCodeC;
        private List taxMapInfoList;
        private Set treeOrganismCodeSet;

        private TaxMapModelUpdater(Collection collection, List list, Set set) {
            this.mappingOrganismCodeC = collection;
            this.taxMapInfoList = list;
            this.treeOrganismCodeSet = set;
        }

        public void execute(ProgressImpl progressImpl) {
            try {
                TaxMapFrame.this.updateTaxModel(this.mappingOrganismCodeC, this.taxMapInfoList, this.treeOrganismCodeSet, progressImpl);
            }
            catch (Exception exception) {
                String string = "Fail to update Taxonomy Mapping Model.";
                logger.warn(string, exception);
                this.setError(true);
                this.setErrorMessage(string);
            }
        }

        public void done() {
            TaxMapFrame.this.updateGUI();
        }
    }
}

