/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoRegister;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.taxonomy.TaxonomyTreeNode;
import cgdp.recog.taxonomy.map.TaxMapModel;
import cgdp.recog.taxonomy.map.TaxMapPropertyCondition;
import cgdp.recog.taxonomy.map.TaxMapUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaxMapGenePropertyCreater2
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxMapGenePropertyCreater2.class);
    private Component parent;
    private TaxMapPropertyCondition condition;
    private List nodeList;
    private TaxMapModel taxMapModel;

    public TaxMapGenePropertyCreater2(Component component, TaxMapPropertyCondition taxMapPropertyCondition, List list, TaxMapModel taxMapModel) {
        this.parent = component;
        this.condition = taxMapPropertyCondition;
        this.nodeList = list;
        this.taxMapModel = taxMapModel;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            progressImpl.setTotal(3);
            Set set = this.createGeneInfoSet();
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            GeneInfoTitle geneInfoTitle = (GeneInfoTitle)this.condition.getInfoTitle();
            ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
            arrayList.add(GeneInfoTitle.TITLE_ORGANISM_CODE);
            arrayList.add(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
            arrayList.add(geneInfoTitle);
            progressImpl.increment();
            Map map = GeneInfoUtil.createOrganismCodeGeneInfoListMap(set);
            geneInfoTitle.addAllOrganismCode(map.keySet());
            GeneInfoRegister.saveGeneInfo(geneInfoTitle.getLocationName(), arrayList, map);
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to save core gene's property.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
    }

    private Set createGeneInfoSet() {
        HashSet<GeneInfo> hashSet = new HashSet<GeneInfo>();
        for (TaxonomyTreeNode taxonomyTreeNode : this.nodeList) {
            List list = this.taxMapModel.getTaxMapInfoList(taxonomyTreeNode);
            List list2 = TaxMapUtil.createGeneInfoList(list);
            for (GeneInfo geneInfo : list2) {
                geneInfo.putInfo(this.condition.getInfoTitle(), taxonomyTreeNode.getName());
                hashSet.add(geneInfo);
            }
        }
        return hashSet;
    }

    public static GeneInfoTitle createTaxMapGeneInfoTitle(String string) {
        GeneInfoTitle geneInfoTitle = GeneInfoTitle.createGeneInfoTitle(string, string, 2, "Global");
        geneInfoTitle.setMulti(true);
        geneInfoTitle.setEditable(true);
        return geneInfoTitle;
    }
}

