/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.taxonomy.map;

import cgdp.recog.taxonomy.map.TaxMapInfo;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class TaxMapImporter
extends FileImporter {
    private static final String DELIMITER = "\t";
    private String filepath;
    private List taxMapInfoList = new ArrayList();
    private Collection organismCodeC = new HashSet();

    public TaxMapImporter(String string) {
        this.filepath = string;
    }

    public void setOrganismCodeC(Collection collection) {
        this.organismCodeC = collection;
    }

    protected String getFilepath() {
        return this.filepath;
    }

    protected void parseDataLine(int n, String string) {
        TaxMapInfo taxMapInfo = TaxMapImporter.createTaxMapInfo(string, this.organismCodeC);
        this.taxMapInfoList.add(taxMapInfo);
    }

    public static TaxMapInfo createTaxMapInfo(String string) {
        return TaxMapImporter.createTaxMapInfo(string, null);
    }

    public static TaxMapInfo createTaxMapInfo(String string, Collection collection) {
        int n;
        String string2;
        Object object;
        String string3;
        Object object2;
        TaxMapInfo taxMapInfo = new TaxMapInfo();
        Vector vector = StringTool.splitString(string, DELIMITER);
        String string4 = (String)vector.get(0);
        if (string4.indexOf(".") != -1) {
            object2 = StringTool.splitString(string, ".");
            int n2 = Integer.parseInt((String)((Vector)object2).get(0));
            int n3 = Integer.parseInt((String)((Vector)object2).get(1));
            taxMapInfo.setClusterId(n2);
            taxMapInfo.setSubClusterId(n3);
        } else {
            int n4 = Integer.parseInt(string4);
            taxMapInfo.setClusterId(n4);
        }
        object2 = (String)vector.get(1);
        Vector vector2 = StringTool.splitString((String)object2, ":");
        String string5 = (String)vector2.get(0);
        if (!CollectionUtil.isNull(collection) && !collection.contains(string5)) {
            return null;
        }
        String string6 = (String)vector2.get(1);
        taxMapInfo.setOrganismCode(string5);
        taxMapInfo.setLocusTag(string6);
        String string7 = ((String)vector.get(2)).trim();
        if (!StringTool.isNull(string7)) {
            int n5 = string7.lastIndexOf("(");
            if (n5 < 0) {
                System.err.println("taxmap info illegal format:" + string7 + ": " + string);
            }
            String string8 = string7.substring(0, n5);
            string3 = string7.substring(n5 + 1, string7.length() - 1);
            object = StringTool.splitString(string3, ",");
            double d = Double.parseDouble((String)((Vector)object).get(0));
            double d2 = Double.parseDouble((String)((Vector)object).get(1));
            taxMapInfo.setLowerName(string8);
            taxMapInfo.setLowerScore(d);
            taxMapInfo.setLowerDist(d2);
        }
        if (!StringTool.isNull(string2 = ((String)vector.get(3)).trim()) && (n = string2.lastIndexOf("(")) >= 0) {
            string3 = string2.substring(0, n);
            object = string2.substring(n + 1, string2.length() - 1);
            Vector vector3 = StringTool.splitString((String)object, ",");
            double d = Double.parseDouble((String)vector3.get(0));
            double d3 = Double.parseDouble((String)vector3.get(1));
            taxMapInfo.setUpperName(string3);
            taxMapInfo.setUpperScore(d);
            taxMapInfo.setUpperDist(d3);
        }
        return taxMapInfo;
    }

    protected void parseHeaderLine(String string) {
    }

    public List getTaxMapInfoList() {
        return this.taxMapInfoList;
    }
}

